/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class PickListItemEditor
extends Panel
implements Serializable,
BlackBox,
KeyListener,
ItemListener,
ItemEditor {
    transient ItemEditSite editSite;
    transient RowFilterListener listener;
    Choice choice = new Choice();
    Variant value;
    boolean cache;
    DataRow locateRow;
    DataSet targetDataSet;
    DataSetView pickListDataSet;
    String[] displayColumns;
    Column[] pickListColumns;
    String[] targetColumns;
    String[] sourceColumns;
    String currentColumnName;

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() == 701) {
            this.editSite.safeEndEdit(true);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.choice.removeFocusListener(focusListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.choice.addFocusListener(focusListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.choice.removeKeyListener(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.choice.addKeyListener(keyListener);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = this.choice.getSelectedIndex();
        switch (n2) {
            case 39: 
            case 40: {
                if (n3 < this.choice.getItemCount() - 1) {
                    this.choice.select(n3 + 1);
                }
                keyEvent.consume();
                break;
            }
            case 37: 
            case 38: {
                if (n3 > 0) {
                    this.choice.select(n3 - 1);
                }
                keyEvent.consume();
                break;
            }
            case 36: {
                this.choice.select(0);
                keyEvent.consume();
                break;
            }
            case 35: {
                this.choice.select(this.choice.getItemCount() - 1);
                keyEvent.consume();
                break;
            }
            case 34: {
                this.choice.select(Math.min(n3 + 10, this.choice.getItemCount() - 1));
                keyEvent.consume();
                break;
            }
            case 33: {
                this.choice.select(Math.max(n3 - 10, 0));
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void endEdit(boolean bl2) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }

    public boolean canPost() {
        return true;
    }

    public void changeBounds(Rectangle rectangle) {
        this.choice.invalidate();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.validate();
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        Column column = null;
        ColumnVariant columnVariant = null;
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.editSite = itemEditSite;
        if (object instanceof ColumnVariant) {
            columnVariant = (ColumnVariant)object;
            this.value.setVariant(columnVariant);
            column = columnVariant.getColumn();
            this.currentColumnName = column.getColumnName();
            this.targetDataSet = columnVariant.getDataSet();
            this.loadPickList(column.getPickList());
            if (this.pickListDataSet == null) {
                itemEditSite.safeEndEdit(false);
            }
        }
        if (this.pickListDataSet != null && this.locateRow != null) {
            try {
                columnVariant.getDataSet();
                ReadRow.copyTo(this.targetColumns, columnVariant.getDataSet(), this.sourceColumns, this.locateRow);
                if (this.pickListDataSet.locate(this.locateRow, 32) && this.choice.getItemCount() > this.pickListDataSet.getRow()) {
                    this.choice.select(this.pickListDataSet.getRow());
                }
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this, dataSetException, true);
            }
        }
        this.choice.invalidate();
        if (itemEditSite != null) {
            this.choice.setBackground(itemEditSite.getBackground());
            this.choice.setForeground(itemEditSite.getForeground());
            this.choice.setFont(itemEditSite.getFont());
        }
        this.validate();
        this.setVisible(true);
        this.choice.requestFocus();
    }

    public Component getComponent() {
        return this;
    }

    public Object getValue() {
        try {
            if (this.pickListDataSet != null) {
                this.pickListDataSet.goToRow(this.choice.getSelectedIndex());
            }
        }
        catch (DataSetException dataSetException) {
            this.value.setUnassignedNull();
            DataSetModel.handleException(this, dataSetException, true);
            Variant variant = this.value;
            return variant;
        }
        return this.pickListDataSet;
    }

    protected void loadPickList(PickListDescriptor pickListDescriptor) {
        if (this.pickListDataSet == null || !this.cache) {
            this.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.pickListDataSet == null) {
                    pickListDescriptor.getPickListDataSet().open();
                    this.pickListDataSet = pickListDescriptor.getPickListDataSet().cloneDataSetView();
                    if (this.pickListDataSet.getRowFilterListener() != null) {
                        this.cache = false;
                    }
                    if (this.listener != null) {
                        if (this.pickListDataSet.getRowFilterListener() != null) {
                            this.pickListDataSet.removeRowFilterListener(this.pickListDataSet.getRowFilterListener());
                        }
                        this.pickListDataSet.addRowFilterListener(this.listener);
                    }
                    this.pickListDataSet.close();
                    this.pickListDataSet.setStorageDataSet(pickListDescriptor.getPickListDataSet().getStorageDataSet());
                    this.sourceColumns = pickListDescriptor.getPickListColumns();
                    this.targetColumns = pickListDescriptor.getDestinationColumns();
                    this.displayColumns = pickListDescriptor.getPickListDisplayColumns();
                    if (this.sourceColumns == null || this.sourceColumns.length == 0 || this.targetColumns == null || this.targetColumns.length == 0 || this.displayColumns == null || this.displayColumns.length == 0) {
                        this.pickListDataSet = null;
                        return;
                    }
                }
                this.pickListDataSet.open();
                this.locateRow = new DataRow((DataSet)this.pickListDataSet, this.sourceColumns);
                if (!this.cache) {
                    this.choice.removeAll();
                }
                int n2 = this.pickListDataSet.getColumn(this.displayColumns[0]).getOrdinal();
                if (this.listener != null || this.listener == null && this.pickListDataSet.getRowFilterListener() != null) {
                    this.pickListDataSet.refilter();
                }
                this.pickListDataSet.first();
                while (this.pickListDataSet.inBounds()) {
                    this.choice.add(this.pickListDataSet.format(n2));
                    this.pickListDataSet.next();
                }
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.choice, "Center");
                }
            }
            catch (Exception exception) {
                this.pickListDataSet = null;
                DataSetModel.handleException(this, exception, true);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public final void removeRowFilterListener(RowFilterListener rowFilterListener) {
        this.listener = null;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.removeRowFilterListener(rowFilterListener);
        }
    }

    public final void addRowFilterListener(RowFilterListener rowFilterListener) throws TooManyListenersException {
        if (rowFilterListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = rowFilterListener;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.addRowFilterListener(rowFilterListener);
        }
    }

    public final boolean isCachePickList() {
        return this.cache;
    }

    public final void setCachePickList(boolean bl2) {
        this.cache = bl2;
    }

    public PickListItemEditor() {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.cache = true;
        this.value = new Variant();
        this.choice.addItemListener(this);
        this.choice.addKeyListener(this);
    }
}

