/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import com.borland.jbcl.layout.XYConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class XYLayout
implements Serializable,
LayoutManager2 {
    static final XYConstraints defaultConstraints = new XYConstraints();
    Hashtable info = new Hashtable();
    int height;
    int width;
    private static final long serialVersionUID = 200L;

    Dimension getLayoutSize(Container container, boolean bl2) {
        Dimension dimension = new Dimension(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            int n2 = container.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                if (!component.isVisible()) continue;
                Rectangle rectangle = this.getComponentBounds(component, bl2);
                dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
            }
        }
        if (this.width > 0) {
            dimension.width = this.width;
        }
        if (this.height > 0) {
            dimension.height = this.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    Rectangle getComponentBounds(Component component, boolean bl2) {
        XYConstraints xYConstraints = (XYConstraints)this.info.get(component);
        if (xYConstraints == null) {
            xYConstraints = defaultConstraints;
        }
        Rectangle rectangle = new Rectangle(xYConstraints.x, xYConstraints.y, xYConstraints.width, xYConstraints.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension;
            Dimension dimension2 = dimension = bl2 ? component.getPreferredSize() : component.getMinimumSize();
            if (rectangle.width <= 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height <= 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof XYConstraints) {
            this.info.put(component, object);
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Rectangle rectangle = this.getComponentBounds(component, true);
            component.setBounds(insets.left + rectangle.x, insets.top + rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component component) {
        this.info.remove(component);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("XYLayout[width=").concat(String.valueOf(this.width))).concat(String.valueOf(",height="))).concat(String.valueOf(this.height))).concat(String.valueOf("]"));
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public XYLayout(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public XYLayout() {
    }
}

