/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.Res;
import com.borland.jbcl.model.WritableMatrixModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BasicMatrixContainer
implements Serializable,
WritableMatrixModel {
    private boolean events = true;
    private transient EventMulticaster modelListeners;
    private boolean variableColumns = true;
    private boolean variableRows = true;
    private int columns;
    private int rows;
    private transient Object[][] items = new Object[0][0];
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.items = (Object[][])objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[][] objectArray = new Object[this.rows][this.columns];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int i3 = 0; i3 < this.columns; ++i3) {
                if (!(this.items[i2][i3] instanceof Serializable)) continue;
                objectArray[i2][i3] = this.items[i2][i3];
            }
        }
        objectOutputStream.writeObject(objectArray);
    }

    private Object[] deleteColumn(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (n2 == 0) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n2 == objectArray2.length) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            System.arraycopy(objectArray, n2 + 1, objectArray2, n2, objectArray2.length - n2);
        }
        return objectArray2;
    }

    private Object[] appendColumn(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    private Object[] insertColumn(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        if (n2 == 0) {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        } else if (n2 == objectArray.length) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            System.arraycopy(objectArray, n2, objectArray2, n2 + 1, objectArray.length - n2);
        }
        return objectArray2;
    }

    protected void processModelEvent(MatrixModelEvent matrixModelEvent) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(matrixModelEvent);
        }
    }

    public void enableModelEvents(boolean bl2) {
        if (this.events != bl2) {
            this.events = bl2;
            if (bl2) {
                this.processModelEvent(new MatrixModelEvent(this, 2));
            }
        }
    }

    public void removeAllColumns() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][0];
        this.items = objectArray;
        this.columns = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void removeColumn(int n2) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        if (n2 >= 0 && n2 < this.columns) {
            Object[][] objectArray = new Object[this.rows][this.columns - 1];
            for (int i2 = 0; i2 < this.rows; ++i2) {
                objectArray[i2] = this.deleteColumn(this.items[i2], n2);
            }
            this.items = objectArray;
            --this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 66, new MatrixLocation(0, n2)));
        }
    }

    public void addColumn(int n2) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        if (n2 >= 0 && n2 < this.columns) {
            Object[][] objectArray = new Object[this.rows][this.columns + 1];
            for (int i2 = 0; i2 < this.rows; ++i2) {
                objectArray[i2] = this.insertColumn(this.items[i2], n2);
            }
            this.items = objectArray;
            ++this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, n2)));
        }
    }

    public void addColumn() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][this.columns + 1];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            objectArray[i2] = this.appendColumn(this.items[i2]);
        }
        this.items = objectArray;
        ++this.columns;
        this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, this.columns - 1)));
    }

    public void setVariableColumns(boolean bl2) {
        this.variableColumns = bl2;
    }

    public boolean isVariableColumns() {
        return this.variableColumns;
    }

    public void removeAllRows() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[0][this.columns];
        this.items = objectArray;
        this.rows = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void removeRow(int n2) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows - 1][this.columns];
        if (n2 == 0) {
            for (int i2 = 0; i2 < this.rows - 1; ++i2) {
                System.arraycopy(this.items[i2 + 1], 0, objectArray[i2], 0, this.items[i2 + 1].length);
            }
        } else if (n2 >= 0 && n2 < this.rows) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                System.arraycopy(this.items[n3], 0, objectArray[n3], 0, this.items[n3].length);
            }
            for (n3 = n2; n3 < this.rows - 1; ++n3) {
                System.arraycopy(this.items[n3 + 1], 0, objectArray[n3], 0, this.items[n3 + 1].length);
            }
        } else {
            return;
        }
        this.items = objectArray;
        --this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 34, new MatrixLocation(n2, 0)));
    }

    public void addRow(int n2) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows + 1][this.columns];
        if (n2 == 0) {
            for (int i2 = 0; i2 < this.rows; ++i2) {
                System.arraycopy(this.items[i2], 0, objectArray[i2 + 1], 0, this.items[i2].length);
            }
        } else if (n2 >= 0 && n2 < this.rows) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                System.arraycopy(this.items[n3], 0, objectArray[n3], 0, this.items[n3].length);
            }
            for (n3 = n2; n3 < this.rows; ++n3) {
                System.arraycopy(this.items[n3], 0, objectArray[n3 + 1], 0, this.items[n3].length);
            }
        } else {
            return;
        }
        this.items = objectArray;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(n2, 0)));
    }

    public void addRow() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows + 1][this.columns];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            System.arraycopy(this.items[i2], 0, objectArray[i2], 0, this.items[i2].length);
        }
        this.items = objectArray;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(this.rows - 1, 0)));
    }

    public void setVariableRows(boolean bl2) {
        this.variableRows = bl2;
    }

    public boolean isVariableRows() {
        return this.variableRows;
    }

    public void touched(int n2, int n3) {
        if (n2 >= 0 && n2 < this.rows && n3 >= 0 && n3 < this.columns) {
            this.processModelEvent(new MatrixModelEvent(this, 33, new MatrixLocation(n2, n3)));
        }
    }

    public void set(int n2, int n3, Object object) {
        if (n2 >= 0 && n2 < this.rows && n3 >= 0 && n3 < this.columns) {
            this.items[n2][n3] = object;
            this.processModelEvent(new MatrixModelEvent(this, 17, new MatrixLocation(n2, n3)));
        }
    }

    public boolean canSet(int n2, int n3, boolean bl2) {
        return n2 >= 0 && n2 < this.rows && n3 >= 0 && n3 < this.columns;
    }

    public void removeModelListener(MatrixModelListener matrixModelListener) {
        this.modelListeners.remove(matrixModelListener);
    }

    public void addModelListener(MatrixModelListener matrixModelListener) {
        this.modelListeners.add(matrixModelListener);
    }

    public void setColumnCount(int n2) {
        if (!this.variableColumns || n2 == this.columns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][n2];
        int n3 = n2 < this.columns ? n2 : this.columns;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            System.arraycopy(this.items[i2], 0, objectArray[i2], 0, n3);
        }
        this.columns = n2;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public int getColumnCount() {
        return this.columns;
    }

    public void setRowCount(int n2) {
        if (!this.variableRows || n2 == this.rows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[n2][this.columns];
        int n3 = n2 < this.rows ? n2 : this.rows;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(this.items[i2], 0, objectArray[i2], 0, this.items[i2].length);
        }
        this.rows = n2;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public int getRowCount() {
        return this.rows;
    }

    public MatrixLocation find(Object object) {
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                Object object2 = this.items[i2][i3];
                if (object2 != object && (object2 == null || !object2.equals(object))) continue;
                return new MatrixLocation(i2, i3);
            }
        }
        return null;
    }

    public Object get(int n2, int n3) {
        if (n2 >= 0 && n2 < this.rows && n3 >= 0 && n3 < this.columns) {
            return this.items[n2][n3];
        }
        return null;
    }

    public void setItems(Object[][] objectArray) {
        this.rows = objectArray.length;
        this.columns = this.rows > 0 ? objectArray[0].length : 0;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public Object[][] getItems() {
        return this.items;
    }

    public BasicMatrixContainer(Object[][] objectArray) {
        this.modelListeners = new EventMulticaster();
        this.rows = objectArray.length;
        this.columns = this.rows > 0 ? objectArray[0].length : 0;
        this.items = objectArray;
    }

    public BasicMatrixContainer(int n2, int n3) {
        this.modelListeners = new EventMulticaster();
        this.rows = n2;
        this.columns = n3;
        this.items = new Object[n2][n3];
    }

    public BasicMatrixContainer() {
        this.modelListeners = new EventMulticaster();
    }
}

