/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.ModelEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;

public class GraphModelEvent
extends ModelEvent
implements Serializable {
    private int change;
    private transient GraphLocation location;
    private transient GraphModel model;
    public static final int NODE_REPLACED = 50;
    public static final int NODE_REMOVED = 34;
    public static final int NODE_ADDED = 18;
    public static final int ITEM_TOUCHED = 33;
    public static final int ITEM_CHANGED = 17;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int CONTENT_CHANGED = 1;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v2 = hashtable.get("m");
        if (v2 instanceof GraphModel) {
            this.model = (GraphModel)v2;
        }
        if ((v2 = hashtable.get("l")) instanceof GraphLocation) {
            this.location = (GraphLocation)v2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.location instanceof Serializable) {
            hashtable.put("l", this.location);
        }
        objectOutputStream.writeObject(hashtable);
    }

    protected String paramString() {
        String string;
        switch (this.change) {
            case 1: {
                string = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                string = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                string = "ITEM_CHANGED";
                break;
            }
            case 33: {
                string = "ITEM_TOUCHED";
                break;
            }
            case 18: {
                string = "NODE_ADDED";
                break;
            }
            case 34: {
                string = "NODE_REMOVED";
                break;
            }
            case 50: {
                string = "NODE_REPLACED";
                break;
            }
            default: {
                string = "<INVALID>";
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",model="))).concat(String.valueOf(this.model))).concat(String.valueOf(",change="))).concat(String.valueOf(string))).concat(String.valueOf(",location="))).concat(String.valueOf(this.location));
    }

    public void dispatch(EventListener eventListener) {
        switch (this.getID()) {
            case 1: {
                ((GraphModelListener)eventListener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((GraphModelListener)eventListener).modelStructureChanged(this);
                break;
            }
        }
    }

    public GraphLocation getLocation() {
        return this.location;
    }

    public int getChange() {
        return this.change;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public GraphModelEvent(GraphModel graphModel, int n2, GraphLocation graphLocation) {
        this(graphModel, n2);
        this.location = graphLocation;
    }

    public GraphModelEvent(GraphModel graphModel, int n2) {
        super(graphModel, n2);
        this.model = graphModel;
        this.change = n2;
    }
}

