/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.ExceptionHandler;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import java.awt.Component;

public class VectorDataSetManager
implements ExceptionHandler,
DataChangeListener,
VectorViewManager,
WritableVectorModel {
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;
    private DataSetModel dataSetModel;
    private DataSet dataSet;

    public void handleException(Exception exception) {
        this.dataSetModel.handleThisException(exception);
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        switch (dataChangeEvent.getID()) {
            case 1: {
                this.processModelEvent(18, dataChangeEvent.getRowAffected());
                break;
            }
            case 2: {
                this.processModelEvent(34, dataChangeEvent.getRowAffected());
                break;
            }
            case 3: 
            case 4: {
                this.processModelEvent(17, dataChangeEvent.getRowAffected());
                break;
            }
            case 5: {
                this.processModelEvent(2, 0);
            }
        }
    }

    private void processModelEvent(int n2, int n3) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, n2, n3));
        }
    }

    public ItemEditor getEditor(int n2, Object object, int n3) {
        return this.dataSetModel.getEditor();
    }

    public ItemPainter getPainter(int n2, Object object, int n3) {
        return this.dataSetModel.getPainter(n2, object);
    }

    public void enableModelEvents(boolean bl2) {
        if (this.events != bl2) {
            this.events = bl2;
            if (bl2) {
                this.processModelEvent(2, 0);
            }
        }
    }

    public void removeAll() {
    }

    public void remove(int n2) {
        this.dataSetModel.removeRow(n2);
    }

    public void addItem(Object object) {
        this.dataSetModel.addRow();
        this.dataSetModel.set(object);
    }

    public void addItem(int n2, Object object) {
        this.dataSetModel.addRow(n2);
        this.dataSetModel.set(object);
    }

    public boolean isVariableSize() {
        return true;
    }

    public void touched(int n2) {
        this.processModelEvent(33, n2);
    }

    public void set(int n2, Object object) {
        this.dataSetModel.set(n2, object);
        this.processModelEvent(17, n2);
    }

    public boolean canSet(int n2, boolean bl2) {
        return this.dataSetModel.canSet(n2, bl2);
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.remove(vectorModelListener);
        if (this.modelListeners.getListenerCount() == 0) {
            this.dataSet.removeDataChangeListener(this);
        }
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.add(vectorModelListener);
        if (this.modelListeners.getListenerCount() == 1) {
            this.dataSet.addDataChangeListener(this);
        }
    }

    public int getCount() {
        return this.dataSetModel.getRowCount();
    }

    public int find(Object object) {
        return -1;
    }

    public Object get(int n2) {
        return this.dataSetModel.get(n2);
    }

    public VectorDataSetManager(DataSet dataSet, Column column, Component component) {
        this.dataSet = dataSet;
        this.dataSetModel = new DataSetModel(dataSet, column, component);
    }

    public VectorDataSetManager(DataSet dataSet, Column column) {
        this(dataSet, column, null);
    }
}

