/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.Res;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.SingletonView;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import com.objectspace.jgl.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class FieldView
extends BeanPanel
implements Serializable,
FocusListener,
KeyListener,
ItemEditSite,
SingletonModelListener,
SingletonView {
    private transient Array customizeListeners;
    private transient CustomItemEditor customEditor;
    private transient CustomItemPainter customPainter;
    protected boolean postOnFocusLost = true;
    private transient SingletonModelMulticaster modelMulticaster;
    private transient KeyMulticaster keyMulticaster;
    private boolean endEditFailed = false;
    private int preferredWidth = 100;
    private int preferredHeight = 20;
    private int alignment = 33;
    private Insets margins;
    private int state;
    private boolean flat = false;
    private DataToolTip toolTip = new DataToolTip(this);
    private boolean showRollover = false;
    private boolean showFocus = true;
    private boolean editInPlace = true;
    private boolean growEditor = true;
    private boolean autoEdit = true;
    private boolean postOnEndEdit = true;
    private boolean selectable = false;
    private Point editClickPoint;
    private ItemEditor editor;
    private boolean readOnly;
    private transient SingletonViewManager viewManager;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModel model;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v2 = hashtable.get("m");
        if (v2 instanceof SingletonModel) {
            this.model = (SingletonModel)v2;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
        if ((v2 = hashtable.get("v")) instanceof SingletonViewManager) {
            this.viewManager = (SingletonViewManager)v2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        objectOutputStream.writeObject(hashtable);
    }

    public synchronized void removeCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners != null) {
            this.customizeListeners.remove(customItemListener);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Array();
        }
        this.customizeListeners.add(customItemListener);
    }

    protected void fireCustomizeItemEvent(Object object, int n2, CustomPaintSite customPaintSite) {
        if (this.customizeListeners != null) {
            customPaintSite.reset();
            for (int i2 = 0; i2 < this.customizeListeners.size(); ++i2) {
                ((CustomItemListener)this.customizeListeners.at(i2)).customizeItem(null, object, n2, customPaintSite);
            }
        }
    }

    private void fireActionEvent() {
        Object object = this.model != null ? this.model.get() : null;
        String string = object != null ? object.toString() : "";
        this.processActionEvent(new ActionEvent(this, 1001, string));
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int n2) {
        this.preferredWidth = n2;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int n2) {
        this.preferredHeight = n2;
    }

    public void doLayout() {
        if (this.editor != null) {
            Rectangle rectangle = this.outerRect();
            this.editor.changeBounds(rectangle);
        }
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getSiteGraphics();
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter = this.getPainter(object);
        Dimension dimension = itemPainter != null ? itemPainter.getPreferredSize(object, graphics, this.state, this) : new Dimension(0, 0);
        Insets insets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (this.preferredHeight > dimension.height) {
            dimension.height = this.preferredHeight;
        }
        if (this.preferredWidth > dimension.width) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        if (this.editor != null) {
            this.safeEndEdit(false);
        }
        this.repaint();
    }

    protected ItemEditor getEditor(Object object) {
        ItemEditor itemEditor;
        ItemEditor itemEditor2 = itemEditor = this.viewManager != null ? this.viewManager.getEditor(object, this.state) : null;
        if (itemEditor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(itemEditor);
            this.fireCustomizeItemEvent(object, this.state, this.customEditor);
            return this.customEditor;
        }
        return itemEditor;
    }

    protected ItemPainter getPainter(Object object) {
        ItemPainter itemPainter;
        ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(object, this.state) : null;
        if (itemPainter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(itemPainter);
            this.fireCustomizeItemEvent(object, this.state, this.customPainter);
            return this.customPainter;
        }
        return itemPainter;
    }

    public void setEnabled(boolean bl2) {
        this.state = bl2 ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
        super.setEnabled(bl2);
    }

    public boolean isEnabled() {
        return (this.state & 1) == 0;
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            this.state &= 0xFFFFFFBF;
            this.repaint();
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (this.toolTip.active && this.getToolTipText(mouseEvent) != null && (rectangle = this.getInnerRect()) != null && this.model != null) {
            Object object;
            this.toolTip.data = object = this.model.get();
            this.toolTip.painter = this.getPainter(object);
            this.toolTip.state = this.state;
            return new Point(rectangle.x, rectangle.y);
        }
        this.toolTip.painter = null;
        return null;
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
        if (this.showRollover) {
            this.state |= 0x40;
            this.repaint();
        }
        if (this.toolTip.active) {
            Object object = this.model != null ? this.model.get() : null;
            Dimension dimension = this.getPreferredInnerSize(object);
            Rectangle rectangle = this.getInnerRect();
            if (!rectangle.contains(dimension.width, dimension.height)) {
                String string = object != null ? object.toString() : Res.getString(12);
                this.setToolTipText(string);
                this.toolTip.data = object;
                this.toolTip.painter = this.getPainter(object);
                this.toolTip.state = this.state;
                return;
            }
            this.toolTip.painter = null;
            this.setToolTipText(null);
        }
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    protected Dimension getPreferredInnerSize(Object object) {
        Graphics graphics = this.getSiteGraphics();
        ItemPainter itemPainter = this.getPainter(object);
        Dimension dimension = new Dimension(0, 0);
        if (itemPainter != null) {
            dimension = itemPainter.getPreferredSize(object, graphics, this.state, this);
        }
        return dimension;
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        super.processMousePressed(mouseEvent);
        if (mouseEvent.isConsumed()) {
            System.err.println("CONSUMED!");
            return;
        }
        this.state &= 0xFFFFFFBF;
        if (!mouseEvent.isMetaDown()) {
            if (this.selectable) {
                this.state = this.isSelected() ? (this.state &= 0xFFFFFFFC) : (this.state |= 4);
            }
            if ((this.state & 2) != 0 && this.editor == null && !this.isReadOnly() && this.writeModel.canSet(false)) {
                this.editClickPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.startEdit();
                return;
            }
            this.state |= 2;
            if (this.isToggleItem()) {
                this.editClickPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.startEdit();
            }
        }
        this.repaint();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.showFocus) {
                    this.state |= 2;
                }
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                this.state &= 0xFFFFFF7F;
                this.repaint();
                break;
            }
            case 1005: {
                this.state &= 0xFFFFFFFD;
                this.state |= 0x80;
                this.repaint();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.state &= 0xFFFFFFFD;
        if (this.postOnFocusLost) {
            this.safeEndEdit(this.postOnEndEdit);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
        Component component;
        char c2 = keyEvent.getKeyChar();
        if (this.editor != null || !this.autoEdit || keyEvent.isConsumed() || this.isReadOnly() || c2 == '\u0000' || c2 == '\t' || c2 == '\r' || c2 == '\n' || c2 == ' ' || c2 == '\u001b' || this.isToggleItem() || keyEvent.isAltDown() ^ keyEvent.isControlDown() || !this.writeModel.canSet(false)) {
            return;
        }
        this.startEdit();
        if (this.editor != null && (component = this.editor.getComponent()) != null) {
            component.dispatchEvent(keyEvent);
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (!keyEvent.isControlDown() || this.editor != null || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem() || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
                break;
            }
            case 32: {
                if (!this.isToggleItem()) break;
                this.startEdit();
                keyEvent.consume();
                break;
            }
            case 25: 
            case 229: {
                if (this.editor != null || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.editor == null) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.endEditFailed) break;
                keyEvent.consume();
                this.fireActionEvent();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                keyEvent.consume();
                break;
            }
            case 9: {
                Component component;
                if (keyEvent.isConsumed() || (component = this.getNextFocusableComponent()) == null) break;
                component.requestFocus();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter = this.getPainter(object);
        Rectangle rectangle = this.getInnerRect();
        if (itemPainter != null) {
            graphics.setColor(this.getBackground());
            graphics.setFont(this.getFont());
            itemPainter.paint(object, graphics, rectangle, this.state, this);
        } else {
            graphics.setColor(Color.red);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private Rectangle outerRect() {
        Dimension dimension = this.getSize();
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    public Rectangle getInnerRect() {
        if (this.flat) {
            return this.outerRect();
        }
        Dimension dimension = this.getSize();
        Insets insets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        Dimension dimension2 = new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        return new Rectangle(insets.left, insets.top, dimension2.width, dimension2.height);
    }

    public Rectangle getInnerRect(Graphics graphics) {
        return this.getInnerRect();
    }

    public void safeEndEdit(boolean bl2) {
        try {
            this.endEdit(bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean bl2) throws Exception {
        this.endEditFailed = false;
        ItemEditor itemEditor = this.editor;
        this.editor = null;
        if (itemEditor != null) {
            boolean bl3 = true;
            try {
                if (!bl2 || (bl3 = itemEditor.canPost())) {
                    if (bl2 && bl3) {
                        this.writeModel.set(itemEditor.getValue());
                    }
                    if (bl3 && itemEditor != null) {
                        Component component = itemEditor.getComponent();
                        itemEditor.endEdit(bl2);
                        itemEditor.removeKeyListener(this);
                        itemEditor.removeKeyListener(this.keyMulticaster);
                        if (component != null) {
                            this.remove(component);
                            component.removeFocusListener(this);
                        }
                        this.editClickPoint = null;
                        itemEditor = null;
                        this.requestFocus();
                    }
                }
            }
            catch (Exception exception) {
                this.endEditFailed = true;
                this.editor = itemEditor;
                throw exception;
            }
        }
        this.editor = itemEditor;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    private boolean isToggleItem() {
        if (this.model == null || this.viewManager == null || !this.editInPlace) {
            return false;
        }
        Object object = this.model.get();
        ItemEditor itemEditor = this.getEditor(object);
        if (itemEditor instanceof ToggleItemEditor) {
            return !this.isReadOnly() && ((ToggleItemEditor)itemEditor).isToggle(object, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this) && this.writeModel.canSet(false);
        }
        return false;
    }

    protected void resyncEditor() {
        if (this.editor != null) {
            Rectangle rectangle = this.getEditorRect();
            this.editor.changeBounds(rectangle != null ? rectangle : new Rectangle());
        }
    }

    protected Rectangle getEditorRect() {
        Component component;
        Rectangle rectangle = null;
        if (this.editor != null && (rectangle = this.outerRect()) != null && this.growEditor && (component = this.editor.getComponent()) != null) {
            Dimension dimension = component.getPreferredSize();
            if (dimension.height > rectangle.height) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    public void startEdit() {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.isReadOnly() || !this.writeModel.canSet(true)) {
            return;
        }
        Object object = this.model.get();
        this.editor = this.getEditor(object);
        if (this.editor != null) {
            Component component = this.editor.getComponent();
            if (component != null) {
                component.setVisible(false);
                this.add(component);
            }
            Rectangle rectangle = this.getEditorRect();
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            this.editor.startEdit(object, rectangle, this);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    public Component getSiteComponent() {
        return this;
    }

    public Graphics getSiteGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
        }
        return graphics;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",selectable="))).concat(String.valueOf(this.selectable))).concat(String.valueOf(",state="))).concat(String.valueOf(this.state));
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl2) {
        this.showRollover = bl2;
    }

    public void setSelected(boolean bl2) {
        this.state = this.selectable && bl2 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public boolean isSelected() {
        return this.selectable && (this.state & 4) != 0;
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public void setDataToolTip(boolean bl2) {
        this.toolTip.active = bl2;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            toolTipManager.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            toolTipManager.unregisterComponent(this);
        }
    }

    public void setSelectable(boolean bl2) {
        this.selectable = bl2;
        if (!this.selectable) {
            this.state &= 0xFFFFFFFC;
            this.repaint(100L);
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
        this.safeEndEdit();
        this.viewManager = singletonViewManager;
        this.repaint();
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
        this.repaint(100L);
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean bl2) {
        if (bl2 != this.flat) {
            this.flat = bl2;
            if (bl2) {
                this.setBorder(null);
            } else {
                this.setBorder(UIManager.getBorder("TextField.border"));
            }
            this.invalidate();
            this.repaint(100L);
        }
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowFocus(boolean bl2) {
        if (this.showFocus != bl2) {
            this.showFocus = bl2;
            this.repaint(100L);
        }
    }

    public void setPostOnFocusLost(boolean bl2) {
        this.postOnFocusLost = bl2;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setGrowEditor(boolean bl2) {
        this.growEditor = bl2;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean bl2) {
        this.autoEdit = bl2;
    }

    public void setPostOnEndEdit(boolean bl2) {
        this.postOnEndEdit = bl2;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setEditInPlace(boolean bl2) {
        this.editInPlace = bl2;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        this.safeEndEdit();
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    protected SingletonViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter())), new TextItemEditor());
    }

    protected SingletonModel createDefaultModel() {
        return new BasicSingletonContainer();
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("TextField.background"));
        super.setForeground(UIManager.getColor("TextField.foreground"));
        super.setBorder(UIManager.getBorder("TextField.border"));
    }

    public FieldView() {
        super(null);
        this.margins = new Insets(2, 2, 2, 2);
        this.keyMulticaster = new KeyMulticaster();
        this.modelMulticaster = new SingletonModelMulticaster();
        this.customPainter = new CustomItemPainter();
        this.customEditor = new CustomItemEditor();
        super.setBackground(UIManager.getColor("TextField.background"));
        super.setForeground(UIManager.getColor("TextField.foreground"));
        super.setBorder(UIManager.getBorder("TextField.border"));
        super.addKeyListener(this.keyMulticaster);
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
    }
}

