/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TextAreaView
extends TextArea
implements Serializable,
SingletonModelListener,
SingletonModelView {
    protected transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected int preferredWidth;
    protected int preferredHeight;
    protected boolean postOnFocusLost = true;
    protected boolean readOnly;
    protected transient WritableSingletonModel writeModel;
    protected transient SingletonModel model;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SingletonModel) {
            this.model = (SingletonModel)object;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int n2) {
        this.preferredWidth = n2;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int n2) {
        this.preferredHeight = n2;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredHeight > dimension.height) {
            dimension = new Dimension(dimension.width, this.preferredHeight);
        }
        if (this.preferredWidth > dimension.width) {
            dimension = new Dimension(this.preferredWidth, dimension.height);
        }
        return dimension;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            String string = super.getText();
            Object object = this.model.get();
            if (this.postOnFocusLost && !string.equals(object)) {
                this.postText();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!this.isReadOnly()) {
            this.writeModel.canSet(true);
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (!keyEvent.isControlDown()) break;
                    this.postText();
                    break;
                }
                case 27: {
                    this.updateText();
                }
            }
        }
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateText();
    }

    protected void postText() {
        if (this.writeModel != null && this.writeModel.canSet(true)) {
            String string = super.getText();
            this.writeModel.set(string);
        }
    }

    public void append(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            super.append(string);
            this.writeModel.set(this.getText());
        }
    }

    public void setText(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            String string2 = this.getText();
            if (string2 == null && string == null) {
                return;
            }
            if (string2 != null && string != null && string2.equals(string)) {
                return;
            }
            this.writeModel.set(string);
        }
    }

    protected void setSuperText(String string) {
        super.setText(string);
    }

    protected void updateText() {
        if (this.model != null) {
            Object object = this.model.get();
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            super.setText(object != null ? object.toString() : "");
            this.setSelectionStart(n2);
            this.setSelectionEnd(n3);
        }
    }

    public void setPostOnFocusLost(boolean bl2) {
        this.postOnFocusLost = bl2;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
        this.setEditable(!this.isReadOnly());
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        this.setEditable(!this.isReadOnly());
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public TextAreaView() {
        this.enableEvents(12L);
    }
}

