/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;

final class Algos {
    private Algos() {
    }

    static final class Printing {
        private Printing() {
        }

        public static String toString(Container container, String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("(");
            boolean bl2 = true;
            ForwardIterator forwardIterator = container.start();
            while (forwardIterator.hasMoreElements()) {
                if (bl2) {
                    stringBuffer.append(" ");
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(forwardIterator.nextElement());
            }
            if (bl2) {
                stringBuffer.append(")");
            } else {
                stringBuffer.append(" )");
            }
            return stringBuffer.toString();
        }
    }

    static final class Hashing {
        static final int HASH_SIZE = 16;

        private Hashing() {
        }

        public static int orderedHash(ForwardIterator forwardIterator, int n2) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            if (n2 >= 16) {
                n5 = n2 / 16;
                forwardIterator.advance(n2 % 16);
            }
            while (forwardIterator.hasMoreElements()) {
                if (forwardIterator.get() != null) {
                    n3 ^= forwardIterator.get().hashCode() / (n4 % 16 + 1);
                }
                ++n4;
                forwardIterator.advance(n5);
            }
            return n3;
        }

        public static int unorderedHash(ForwardIterator forwardIterator) {
            int n2 = 0;
            while (forwardIterator.hasMoreElements()) {
                if (forwardIterator.get() != null) {
                    n2 ^= forwardIterator.get().hashCode();
                }
                forwardIterator.advance();
            }
            return n2;
        }
    }

    static final class Comparing {
        private Comparing() {
        }

        public static boolean equal(Container container, Container container2) {
            if (container.size() != container2.size()) {
                return false;
            }
            ForwardIterator forwardIterator = container.start();
            ForwardIterator forwardIterator2 = container2.start();
            while (forwardIterator.hasMoreElements()) {
                if (forwardIterator.nextElement().equals(forwardIterator2.nextElement())) continue;
                return false;
            }
            return true;
        }
    }

    static final class Removing {
        private Removing() {
        }

        public static ForwardIterator remove(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object) {
            if ((forwardIterator = (ForwardIterator)Finding.find(forwardIterator, forwardIterator2, object)).equals(forwardIterator2)) {
                return forwardIterator;
            }
            ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
            forwardIterator3.advance();
            while (!forwardIterator3.equals(forwardIterator2)) {
                if (!forwardIterator3.get().equals(object)) {
                    forwardIterator.put(forwardIterator3.get());
                    forwardIterator.advance();
                }
                forwardIterator3.advance();
            }
            return forwardIterator;
        }
    }

    static final class Finding {
        private Finding() {
        }

        public static InputIterator find(InputIterator inputIterator, InputIterator inputIterator2, Object object) {
            InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
            while (!inputIterator3.equals(inputIterator2) && !inputIterator3.get().equals(object)) {
                inputIterator3.advance();
            }
            return inputIterator3;
        }
    }

    static final class Replacing {
        private Replacing() {
        }

        public static int replace(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object, Object object2) {
            ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
            int n2 = 0;
            while (!forwardIterator3.equals(forwardIterator2)) {
                if (forwardIterator3.get().equals(object)) {
                    forwardIterator3.put(object2);
                    ++n2;
                }
                forwardIterator3.advance();
            }
            return n2;
        }
    }

    static final class Counting {
        private Counting() {
        }

        public static int count(InputIterator inputIterator, InputIterator inputIterator2, Object object) {
            InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
            int n2 = 0;
            while (!inputIterator3.equals(inputIterator2)) {
                if (!inputIterator3.nextElement().equals(object)) continue;
                ++n2;
            }
            return n2;
        }
    }
}

