/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.HashMapIterator;
import com.objectspace.jgl.Map;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.xEqualTo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class HashMap
extends Map {
    static final int DEFAULT_SIZE = 257;
    static final float DEFAULT_RATIO = 0.75f;
    BinaryPredicate comparator;
    boolean allowDups;
    boolean expandActive = true;
    transient int size;
    transient HashMapNode[] buckets;
    int length;
    int limit;
    float ratio;
    static final long serialVersionUID = 6756413513418169292L;

    public HashMap() {
        this(new xEqualTo(), false, 257, 0.75f);
    }

    public HashMap(boolean bl2) {
        this(new xEqualTo(), bl2, 257, 0.75f);
    }

    public HashMap(BinaryPredicate binaryPredicate) {
        this(binaryPredicate, false, 257, 0.75f);
    }

    public HashMap(BinaryPredicate binaryPredicate, boolean bl2) {
        this(binaryPredicate, bl2, 257, 0.75f);
    }

    public HashMap(BinaryPredicate binaryPredicate, int n2, float f2) {
        this(binaryPredicate, false, n2, f2);
    }

    public HashMap(BinaryPredicate binaryPredicate, boolean bl2, int n2, float f2) {
        this.comparator = binaryPredicate;
        this.ratio = f2;
        this.length = n2;
        this.limit = (int)((float)this.length * this.ratio);
        this.buckets = new HashMapNode[this.length];
        this.allowDups = bl2;
    }

    public HashMap(HashMap hashMap) {
        this.copy(hashMap);
    }

    public boolean allowsDuplicates() {
        return this.allowDups;
    }

    public BinaryPredicate getComparator() {
        return this.comparator;
    }

    public float getLoadRatio() {
        return this.ratio;
    }

    public synchronized Object clone() {
        return new HashMap(this);
    }

    public synchronized void copy(HashMap hashMap) {
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            this.comparator = hashMap.comparator;
            this.length = hashMap.length;
            this.ratio = hashMap.ratio;
            this.limit = hashMap.limit;
            this.size = hashMap.size();
            this.buckets = new HashMapNode[this.length];
            this.allowDups = hashMap.allowDups;
            int n2 = 0;
            while (n2 < this.length) {
                HashMapNode hashMapNode = null;
                HashMapNode hashMapNode2 = hashMap.buckets[n2];
                while (hashMapNode2 != null) {
                    HashMapNode hashMapNode3 = new HashMapNode();
                    hashMapNode3.key = hashMapNode2.key;
                    hashMapNode3.value = hashMapNode2.value;
                    hashMapNode3.hash = hashMapNode2.hash;
                    if (this.buckets[n2] == null) {
                        this.buckets[n2] = hashMapNode3;
                    } else {
                        hashMapNode.next = hashMapNode3;
                    }
                    hashMapNode = hashMapNode3;
                    hashMapNode2 = hashMapNode2.next;
                }
                ++n2;
            }
            return;
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "HashMap");
    }

    public synchronized Enumeration elements() {
        return new HashMapIterator(this.first(), this, 3);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized HashMapIterator begin() {
        return new HashMapIterator(this.first(), this, 1);
    }

    public synchronized HashMapIterator end() {
        return new HashMapIterator(null, this, 1);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        return object instanceof HashMap && this.equals((HashMap)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(HashMap hashMap) {
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            if (this.size() != hashMap.size()) {
                return false;
            }
            if (this.allowDups) {
                Object object = null;
                HashMapIterator hashMapIterator = this.begin();
                while (hashMapIterator.hasMoreElements()) {
                    Object object2 = hashMapIterator.key();
                    if (object == null || !object2.equals(object)) {
                        object = object2;
                        if (!this.same(this.values(object2), hashMap.values(object2))) {
                            return false;
                        }
                    }
                    hashMapIterator.advance();
                }
            } else {
                HashMapIterator hashMapIterator = this.begin();
                while (hashMapIterator.hasMoreElements()) {
                    Object object = hashMap.get(hashMapIterator.key());
                    if (object == null) return false;
                    if (!object.equals(hashMapIterator.value())) {
                        return false;
                    }
                    hashMapIterator.advance();
                }
            }
            return true;
        }
    }

    public synchronized int hashCode() {
        HashMapIterator hashMapIterator = new HashMapIterator(this.first(), this, 2);
        return Algos.Hashing.unorderedHash(hashMapIterator);
    }

    public synchronized void swap(HashMap hashMap) {
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            int n2 = this.size;
            this.size = hashMap.size();
            hashMap.size(n2);
            HashMapNode[] hashMapNodeArray = this.buckets;
            this.buckets = hashMap.buckets;
            hashMap.buckets = hashMapNodeArray;
            int n3 = this.length;
            this.length = hashMap.length;
            hashMap.length = n3;
            int n4 = this.limit;
            this.limit = hashMap.limit;
            hashMap.limit = n4;
            float f2 = this.ratio;
            this.ratio = hashMap.ratio;
            hashMap.ratio = f2;
            boolean bl2 = this.allowDups;
            this.allowDups = hashMap.allowDups;
            hashMap.allowDups = bl2;
            return;
        }
    }

    public synchronized void clear() {
        this.buckets = new HashMapNode[this.length];
        this.size = 0;
    }

    public Object remove(Object object) {
        return this.removeAux((Object)object, (int)this.size).first;
    }

    public int remove(Object object, int n2) {
        Pair pair = this.removeAux(object, n2);
        return ((Number)pair.second).intValue();
    }

    synchronized Pair removeAux(Object object, int n2) {
        if (n2 > 0) {
            int n3 = object.hashCode() & Integer.MAX_VALUE;
            int n4 = n3 % this.length;
            HashMapNode hashMapNode = this.buckets[n4];
            HashMapNode hashMapNode2 = null;
            while (hashMapNode != null) {
                if (hashMapNode.hash == n3 && this.comparator.execute(hashMapNode.key, object)) {
                    int n5 = 1;
                    --n2;
                    HashMapNode hashMapNode3 = hashMapNode.next;
                    Object object2 = hashMapNode.value;
                    if (this.allowDups) {
                        while (n2 > 0 && hashMapNode3 != null && hashMapNode3.hash == n3 && this.comparator.execute(hashMapNode3.key, object)) {
                            ++n5;
                            --n2;
                            hashMapNode3 = hashMapNode3.next;
                        }
                    }
                    if (hashMapNode2 == null) {
                        this.buckets[n4] = hashMapNode3;
                    } else {
                        hashMapNode2.next = hashMapNode3;
                    }
                    this.size -= n5;
                    return new Pair(object2, new Integer(n5));
                }
                hashMapNode2 = hashMapNode;
                hashMapNode = hashMapNode.next;
            }
        }
        return new Pair(null, new Integer(0));
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object remove(Enumeration var1_1) {
        block4: {
            if (!(var1_1 instanceof HashMapIterator)) {
                throw new IllegalArgumentException("Enumeration not a HashMapIterator");
            }
            if (((HashMapIterator)var1_1).myHashMap != this) {
                throw new IllegalArgumentException("Enumeration not for this HashMap");
            }
            var2_2 = ((HashMapIterator)var1_1).myNode;
            var3_3 = var2_2.hash % this.length;
            var4_4 = this.buckets[var3_3];
            if (var2_2 != var4_4) ** GOTO lbl12
            this.buckets[var3_3] = var2_2.next;
            break block4;
lbl-1000:
            // 1 sources

            {
                var4_4 = var4_4.next;
lbl12:
                // 2 sources

                ** while (var4_4.next != var2_2)
            }
lbl13:
            // 1 sources

            var4_4.next = var2_2.next;
        }
        --this.size;
        if (var2_2 == null) {
            return null;
        }
        return var2_2.value;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof HashMapIterator) || !(enumeration2 instanceof HashMapIterator)) {
            throw new IllegalArgumentException("Enumeration not a HashMapIterator");
        }
        if (((HashMapIterator)enumeration).myHashMap != this || ((HashMapIterator)enumeration2).myHashMap != this) {
            throw new IllegalArgumentException("Enumeration not for this HashMap");
        }
        HashMapIterator hashMapIterator = (HashMapIterator)enumeration;
        HashMapIterator hashMapIterator2 = (HashMapIterator)enumeration2;
        int n2 = 0;
        while (!hashMapIterator.equals(hashMapIterator2)) {
            HashMapIterator hashMapIterator3 = new HashMapIterator(hashMapIterator);
            hashMapIterator3.advance();
            this.remove(hashMapIterator);
            hashMapIterator = hashMapIterator3;
            ++n2;
        }
        return n2;
    }

    public synchronized HashMapIterator find(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashMapNode hashMapNode = this.buckets[n2 % this.length];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                return new HashMapIterator(hashMapNode, this, 1);
            }
            hashMapNode = hashMapNode.next;
        }
        return new HashMapIterator(null, this, 1);
    }

    public synchronized int count(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashMapNode hashMapNode = this.buckets[n2 % this.length];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                if (this.allowDups) {
                    int n3 = 1;
                    hashMapNode = hashMapNode.next;
                    while (hashMapNode != null && n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                        ++n3;
                        hashMapNode = hashMapNode.next;
                    }
                    return n3;
                }
                return 1;
            }
            hashMapNode = hashMapNode.next;
        }
        return 0;
    }

    public synchronized int countValues(Object object) {
        return Algos.Counting.count(new HashMapIterator(this.first(), this, 3), new HashMapIterator(null, this, 3), object);
    }

    public synchronized Object get(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashMapNode hashMapNode = this.buckets[n2 % this.length];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                return hashMapNode.value;
            }
            hashMapNode = hashMapNode.next;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.length;
        HashMapNode hashMapNode = this.buckets[n3];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                hashMapNode.key = object;
                Object object3 = hashMapNode.value;
                hashMapNode.value = object2;
                return object3;
            }
            hashMapNode = hashMapNode.next;
        }
        HashMapNode hashMapNode2 = new HashMapNode();
        hashMapNode2.key = object;
        hashMapNode2.value = object2;
        hashMapNode2.hash = n2;
        hashMapNode2.next = this.buckets[n3];
        this.buckets[n3] = hashMapNode2;
        if (++this.size > this.limit) {
            this.expand();
        }
        return null;
    }

    public Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Pair)) {
            throw new IllegalArgumentException("object is not pair");
        }
        if (((Pair)object).first == null || ((Pair)object).second == null) {
            throw new NullPointerException();
        }
        Pair pair = (Pair)object;
        return this.add(pair.first, pair.second);
    }

    public synchronized Object add(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.length;
        HashMapNode hashMapNode = this.buckets[n3];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                if (this.allowDups) {
                    HashMapNode hashMapNode2 = new HashMapNode();
                    hashMapNode2.key = object;
                    hashMapNode2.value = object2;
                    hashMapNode2.hash = n2;
                    hashMapNode2.next = hashMapNode.next;
                    hashMapNode.next = hashMapNode2;
                    if (++this.size > this.limit) {
                        this.expand();
                    }
                    return null;
                }
                return hashMapNode.value;
            }
            hashMapNode = hashMapNode.next;
        }
        HashMapNode hashMapNode3 = new HashMapNode();
        hashMapNode3.key = object;
        hashMapNode3.value = object2;
        hashMapNode3.hash = n2;
        hashMapNode3.next = this.buckets[n3];
        this.buckets[n3] = hashMapNode3;
        if (++this.size > this.limit) {
            this.expand();
        }
        return null;
    }

    public synchronized Enumeration keys() {
        return new HashMapIterator(this.first(), this, 2);
    }

    public synchronized Enumeration keys(Object object) {
        Array array = new Array();
        HashMapIterator hashMapIterator = this.begin();
        while (hashMapIterator.hasMoreElements()) {
            if (hashMapIterator.value().equals(object)) {
                array.pushBack(hashMapIterator.key());
            }
            hashMapIterator.advance();
        }
        return array.elements();
    }

    public synchronized Enumeration values(Object object) {
        Array array = new Array();
        Range range = this.equalRange(object);
        HashMapIterator hashMapIterator = (HashMapIterator)range.begin;
        HashMapIterator hashMapIterator2 = (HashMapIterator)range.end;
        while (!hashMapIterator.equals(hashMapIterator2)) {
            array.add(hashMapIterator.value());
            hashMapIterator.advance();
        }
        return array.elements();
    }

    public synchronized HashMapIterator lowerBound(Object object) {
        return (HashMapIterator)this.equalRange((Object)object).begin;
    }

    public synchronized HashMapIterator upperBound(Object object) {
        return (HashMapIterator)this.equalRange((Object)object).end;
    }

    public synchronized Range equalRange(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashMapNode hashMapNode = this.buckets[n2 % this.length];
        while (hashMapNode != null) {
            if (n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                HashMapNode hashMapNode2 = hashMapNode;
                hashMapNode = hashMapNode.next == null ? this.next(hashMapNode) : hashMapNode.next;
                while (hashMapNode != null && n2 == hashMapNode.hash && this.comparator.execute(hashMapNode.key, object)) {
                    HashMapNode hashMapNode3 = hashMapNode = hashMapNode.next == null ? this.next(hashMapNode) : hashMapNode.next;
                }
                return new Range(new HashMapIterator(hashMapNode2, this, 1), new HashMapIterator(hashMapNode, this, 1));
            }
            hashMapNode = hashMapNode.next;
        }
        return new Range(this.end(), this.end());
    }

    private HashMapNode first() {
        if (this.size > 0) {
            int n2 = 0;
            while (n2 < this.length) {
                if (this.buckets[n2] != null) {
                    return this.buckets[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    private HashMapNode next(HashMapNode hashMapNode) {
        int n2 = hashMapNode.hash % this.length + 1;
        while (n2 < this.length) {
            if (this.buckets[n2] != null) {
                return this.buckets[n2];
            }
            ++n2;
        }
        return null;
    }

    public boolean expansionAllowed() {
        return this.expandActive;
    }

    public synchronized void allowExpansion(boolean bl2) {
        this.expandActive = bl2;
    }

    protected int nextBucketSize(int n2) {
        return n2 * 2 + 1;
    }

    private void expand() {
        if (!this.expansionAllowed()) {
            return;
        }
        int n2 = this.nextBucketSize(this.length);
        HashMapNode[] hashMapNodeArray = new HashMapNode[n2];
        int n3 = 0;
        while (n3 < this.length) {
            HashMapNode hashMapNode = this.buckets[n3];
            while (hashMapNode != null) {
                HashMapNode hashMapNode2 = hashMapNode;
                hashMapNode = hashMapNode.next;
                int n4 = hashMapNode2.hash % n2;
                hashMapNode2.next = hashMapNodeArray[n4];
                hashMapNodeArray[n4] = hashMapNode2;
            }
            ++n3;
        }
        this.buckets = hashMapNodeArray;
        this.length = n2;
        this.limit = (int)((float)this.length * this.ratio);
    }

    private boolean same(Enumeration enumeration, Enumeration enumeration2) {
        Array array = new Array();
        Array array2 = new Array();
        while (enumeration.hasMoreElements()) {
            array.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            array2.add(enumeration2.nextElement());
        }
        if (array.size() != array2.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < array.size()) {
            Object object = array.at(n2);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < array2.size()) {
                if (array.at(n5).equals(object)) {
                    ++n3;
                }
                if (array2.at(n5).equals(object)) {
                    ++n4;
                }
                ++n5;
            }
            if (n3 != n4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void size(int n2) {
        this.size = n2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        HashMapIterator hashMapIterator = this.begin();
        while (hashMapIterator.hasMoreElements()) {
            objectOutputStream.writeObject(hashMapIterator.nextElement());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buckets = new HashMapNode[this.length];
        int n2 = objectInputStream.readInt();
        while (n2-- > 0) {
            this.add(objectInputStream.readObject());
        }
    }

    static final class HashMapNode {
        Object key;
        Object value;
        int hash;
        HashMapNode next;

        HashMapNode() {
        }
    }
}

