/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.VectorArray;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class VectorIterator
implements RandomAccessIterator,
Serializable {
    VectorArray buffer;
    int index;
    static final long serialVersionUID = 6819025880408038288L;

    public static VectorIterator begin(Vector vector) {
        return new VectorIterator(vector, 0);
    }

    public static VectorIterator end(Vector vector) {
        return new VectorIterator(vector, vector.size());
    }

    public VectorIterator() {
        this(new Vector(), 0);
    }

    public VectorIterator(VectorIterator vectorIterator) {
        this.buffer = vectorIterator.buffer;
        this.index = vectorIterator.index;
    }

    public VectorIterator(Vector vector, int n2) {
        this(new VectorArray(vector), n2);
    }

    public VectorIterator(VectorArray vectorArray, int n2) {
        this.buffer = vectorArray;
        this.index = n2;
    }

    public Object clone() {
        return new VectorIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof VectorIterator)) break block2;
                VectorIterator vectorIterator = (VectorIterator)object;
                if (vectorIterator.index == this.index && (vectorIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(VectorIterator vectorIterator) {
        return vectorIterator.index == this.index && vectorIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((VectorIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.buffer.array.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.buffer.array.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Object e2 = this.buffer.array.elementAt(this.index);
            ++this.index;
            return e2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("VectorIterator");
        }
    }

    public Object get() {
        return this.buffer.array.elementAt(this.index);
    }

    public Object get(int n2) {
        return this.buffer.array.elementAt(this.index + n2);
    }

    public void put(Object object) {
        this.buffer.array.setElementAt(object, this.index);
    }

    public void put(int n2, Object object) {
        this.buffer.array.setElementAt(object, this.index + n2);
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof VectorIterator) || this.buffer.array != ((VectorIterator)forwardIterator2).buffer.array && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((VectorIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.buffer;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof VectorIterator && this.buffer.array == ((VectorIterator)inputIterator).buffer.array;
    }
}

