/*
 * Decompiled with CFR 0.152.
 */
package examples.ejb.basic.containerManaged;

import examples.ejb.basic.containerManaged.ProcessingErrorException;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

public class AccountBean
implements EntityBean {
    static final boolean VERBOSE = true;
    private EntityContext ctx;
    public String accountId;
    public double balance;
    public String accountType;
    private transient boolean isDirty;

    public String accountType() {
        this.log("AccountBean.accountType (" + this.id() + ")");
        return this.accountType;
    }

    public double balance() {
        this.log("AccountBean.balance (" + this.id() + ")");
        return this.balance;
    }

    public double deposit(double d) {
        this.log("AccountBean.deposit: Depositing $" + d + " into '" + this.accountId + "'");
        this.balance += d;
        this.setModified(true);
        return this.balance;
    }

    public void ejbActivate() {
        this.log("AccountBean.ejbActivate (" + this.id() + ")");
    }

    public String ejbCreate(String string, double d, String string2) throws CreateException {
        this.log("AccountBean.ejbCreate( id = " + System.identityHashCode(this) + ", PK = " + string + ", " + "initial balance = $ " + d + ")");
        this.accountId = string;
        this.balance = d;
        this.accountType = string2;
        return null;
    }

    public void ejbLoad() {
        this.log("AccountBean.ejbLoad (" + this.id() + ")");
    }

    public void ejbPassivate() {
        this.log("AccountBean.ejbPassivate (" + this.id() + ")");
    }

    public void ejbPostCreate(String string, double d, String string2) {
        this.log("AccountBean.ejbPostCreate (" + this.id() + ")");
    }

    public void ejbRemove() throws RemoveException {
        this.log("AccountBean.ejbRemove (" + this.id() + ")");
    }

    public void ejbStore() {
        this.log("AccountBean.ejbStore (" + this.id() + ")");
        this.setModified(false);
    }

    private String id() {
        return System.identityHashCode(this) + ", PK = " + (this.ctx == null ? "nullctx" : (this.ctx.getPrimaryKey() == null ? "null" : this.ctx.getPrimaryKey().toString())) + "; isDirty = " + this.isDirty;
    }

    public boolean isModified() {
        this.log("isModified(): isDirty = " + (this.isDirty ? "true" : "false"));
        return this.isDirty;
    }

    private void log(String string) {
        System.out.println(string);
    }

    public void setEntityContext(EntityContext entityContext) {
        this.log("setEntityContext called (" + this.id() + ")");
        this.ctx = entityContext;
    }

    public void setModified(boolean bl) {
        this.isDirty = bl;
        this.log("setModified(): " + this.id() + (bl ? ": requires saving" : ": saving not required"));
    }

    public void unsetEntityContext() {
        this.log("AccountBean.unsetEntityContext");
        this.ctx = null;
    }

    public double withdraw(double d) throws ProcessingErrorException {
        this.log("AccountBean.withdraw: Withdrawing $" + d + " from '" + this.accountId + "'");
        if (d > this.balance) {
            throw new ProcessingErrorException("Request to withdraw $" + d + "; is more than balance $" + this.balance + " in account " + this.accountId);
        }
        this.balance -= d;
        this.setModified(true);
        return this.balance;
    }
}

