/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.authentication.util;

import COM.cloudscape.authentication.Interface.AuthenticationException;
import COM.cloudscape.authentication.Interface.AuthenticationScheme;
import c8e._v.a;
import c8e.a.b;
import c8e.bp.c;
import c8e.bp.d;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SimpleAuthenticationScheme
implements AuthenticationScheme {
    public static final String USER_PROPERTY_PREFIX = "cloudscape.user.";
    private static final String USERS_DEFAULT_CONFIG_FILE = "users.properties";
    private static final String DB_USERS_LIST_PROPERTY_PREFIX = "cloudscape.database.users.";
    private Properties usersProperties;
    private Hashtable databasesUsers;

    public SimpleAuthenticationScheme() throws c8e.c_.b, IOException {
        this.loadUsersConfigurationFile();
        if (this.usersProperties != null) {
            this.setDatabaseUsers(this.usersProperties);
        } else {
            try {
                this.setDatabaseUsers(System.getProperties());
            }
            catch (SecurityException securityException) {}
            this.setDatabaseUsers(d.getMonitor().getApplicationProperties());
        }
    }

    public void authenticateUser(String string, String string2, String string3, Properties properties) throws AuthenticationException {
        Hashtable hashtable;
        if (string == null) {
            throw AuthenticationException.loginFailed();
        }
        String string4 = this.usersProperties == null ? a.getSystemProperty(USER_PROPERTY_PREFIX + string) : this.usersProperties.getProperty(USER_PROPERTY_PREFIX + string);
        if (string4 == null) {
            throw AuthenticationException.loginFailed();
        }
        if (!string4.equals(string2)) {
            throw AuthenticationException.loginFailed();
        }
        if (string3 != null && this.databasesUsers != null && (hashtable = (Hashtable)this.databasesUsers.get(string3)) != null && hashtable.get(string) == null) {
            throw AuthenticationException.notAValidDatabaseUser(string, string3);
        }
    }

    public String toString() {
        return c8e.g.d.getTextMessage("A017");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadUsersConfigurationFile() throws IOException {
        InputStream inputStream;
        block9: {
            block8: {
                inputStream = null;
                Properties properties = null;
                c c2 = d.getMonitor();
                try {
                    inputStream = c2.getSystemResourceAsStream(USERS_DEFAULT_CONFIG_FILE);
                    if (inputStream == null) {
                        Object var5_4 = null;
                        break block8;
                    }
                    properties = new Properties();
                    properties.load(new BufferedInputStream(inputStream));
                    Enumeration<?> enumeration = properties.propertyNames();
                    if (enumeration.hasMoreElements()) {
                        this.usersProperties = properties;
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        inputStream = null;
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (IOException iOException) {}
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        Object var5_5 = null;
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return;
        inputStream.close();
        return;
    }

    private void setDatabaseUsers(Properties properties) {
        Hashtable<String, String> hashtable = null;
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(DB_USERS_LIST_PROPERTY_PREFIX)) continue;
            String string2 = string.substring(DB_USERS_LIST_PROPERTY_PREFIX.length());
            d.logTextMessage("A018", DB_USERS_LIST_PROPERTY_PREFIX, string2, b.getProductVersion());
            String string3 = properties.getProperty(string);
            if (string3.length() == 0 || !(stringTokenizer = new StringTokenizer(string3, ",")).hasMoreElements()) continue;
            if (this.databasesUsers == null) {
                this.databasesUsers = new Hashtable();
            }
            if ((hashtable = (Hashtable<String, String>)this.databasesUsers.get(string2)) == null) {
                hashtable = new Hashtable<String, String>();
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                hashtable.put(string4, string4);
            }
            this.databasesUsers.put(string2, hashtable);
        }
    }

    private void dumpUsersConfig() {
        Properties properties = null;
        Properties properties2 = null;
        c8e.x_.a a2 = c8e.bk.a.GET_DEBUG_STREAM();
        a2.println("\n----------BEGIN USERS CONFIG DUMP-----------\n");
        if (this.usersProperties != null) {
            properties = this.usersProperties;
        } else {
            try {
                properties = System.getProperties();
            }
            catch (SecurityException securityException) {}
            properties2 = d.getMonitor().getApplicationProperties();
        }
        a2.println("[DEFINED USERS]");
        this.dumpUsers(properties, a2);
        this.dumpUsers(properties2, a2);
        a2.println("[DEFINED USERS END]\n");
        a2.println("[DATABASE USERS (restriction lists)] - BEGIN");
        this.dumpDBUsersList(a2);
        a2.println("[DATABASE USERS (restriction lists) - END]");
        a2.println("\n-----------END USERS CONFIG DUMP------------\n");
    }

    private void dumpUsers(Properties properties, c8e.x_.a a2) {
        boolean bl2 = true;
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(USER_PROPERTY_PREFIX)) continue;
            if (!bl2) {
                a2.print(", ");
            } else {
                a2.print("\nUsers = { ");
                bl2 = false;
            }
            a2.print(string.substring(USER_PROPERTY_PREFIX.length()));
        }
        if (!bl2) {
            a2.println(" }\n");
        }
    }

    private void dumpDBUsersList(c8e.x_.a a2) {
        boolean bl2 = true;
        if (this.databasesUsers == null) {
            return;
        }
        Enumeration enumeration = this.databasesUsers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            a2.print("\nDatabase " + string + " = { ");
            Hashtable hashtable = (Hashtable)this.databasesUsers.get(string);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                if (!bl2) {
                    a2.print(", ");
                } else {
                    bl2 = false;
                }
                a2.print((String)enumeration2.nextElement());
            }
            a2.println(" }");
        }
    }
}

