/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.core;

import COM.cloudscape.util.DriverUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public abstract class AbstractDataSource
implements Referenceable,
Serializable {
    static final String DATABASE_NAME = "databaseName";
    static final String DATASOURCE_NAME = "dataSourceName";
    static final String DESCRIPTION = "description";
    static final String CREATE_DATABASE = "createDatabase";
    static final String SHUTDOWN_DATABASE = "shutdownDatabase";
    static final String CLOUDSCAPE_PROPERTIES = "cloudscapeProperties";
    static final String REMOTE_DATASOURCE_PROTOCOL = "remoteDataSourceProtocol";
    static final String CREATE = "create";
    static final String SHUTDOWN = "shutdown";
    private static final long serialVersionUID = -2091638072335339763L;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String cloudscapeProperties;
    private String remoteDataSourceProtocol;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    protected static transient Driver driver;

    AbstractDataSource() {
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "COM.cloudscape.core.DataSourceFactory", null);
        reference.add(new StringRefAddr(DATABASE_NAME, this.getDatabaseName()));
        reference.add(new StringRefAddr(DATASOURCE_NAME, this.getDataSourceName()));
        reference.add(new StringRefAddr(DESCRIPTION, this.getDescription()));
        if (this.createDatabase != null) {
            reference.add(new StringRefAddr(CREATE_DATABASE, CREATE));
        }
        if (this.shutdownDatabase != null) {
            reference.add(new StringRefAddr(SHUTDOWN_DATABASE, SHUTDOWN));
        }
        if (this.cloudscapeProperties != null) {
            reference.add(new StringRefAddr(CLOUDSCAPE_PROPERTIES, this.cloudscapeProperties));
        }
        if (this.remoteDataSourceProtocol != null) {
            reference.add(new StringRefAddr(REMOTE_DATASOURCE_PROTOCOL, this.remoteDataSourceProtocol));
        }
        return reference;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.equalsIgnoreCase(CREATE) ? string : null;
    }

    public String getCreateDatabase() {
        return this.createDatabase;
    }

    public void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase(SHUTDOWN) ? string : null;
    }

    public String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public void setCloudscapeProperties(String string) {
        this.cloudscapeProperties = string;
    }

    public String getCloudscapeProperties() {
        return this.cloudscapeProperties;
    }

    public void setRemoteDataSourceProtocol(String string) {
        this.remoteDataSourceProtocol = string.equalsIgnoreCase("rmi") ? "rmi:" : string;
    }

    public String getRemoteDataSourceProtocol() {
        return this.remoteDataSourceProtocol;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n2) throws SQLException {
        this.loginTimeout = n2;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    public Connection getDatabaseConnection() throws SQLException {
        Properties properties = new Properties();
        return this.getConnectionViaDriver(properties);
    }

    public Connection getDatabaseConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", string);
        ((Hashtable)properties).put("password", string2);
        return this.getConnectionViaDriver(properties);
    }

    Connection getConnectionViaDriver(Properties properties) throws SQLException {
        String string = this.makeURL();
        this.populateInfo(properties);
        this.findDriver(string);
        return driver.connect(string, properties);
    }

    public void populateInfo(Properties properties) {
        if (this.createDatabase != null) {
            ((Hashtable)properties).put(CREATE, "true");
        }
        if (this.shutdownDatabase != null) {
            ((Hashtable)properties).put(SHUTDOWN, "true");
        }
    }

    protected void findDriver(String string) throws SQLException {
        if (driver == null || !driver.acceptsURL(string)) {
            AbstractDataSource abstractDataSource = this;
            synchronized (abstractDataSource) {
                if (driver == null || !driver.acceptsURL(string)) {
                    try {
                        DriverUtil.loadDriverIfKnown(string);
                    }
                    catch (Exception exception) {}
                    driver = DriverManager.getDriver(string);
                }
            }
        }
    }

    public String makeURL() {
        String string = null;
        string = this.remoteDataSourceProtocol == null ? "jdbc:cloudscape:" + this.getDatabaseName() : "jdbc:cloudscape:" + this.remoteDataSourceProtocol + this.getDatabaseName();
        if (this.cloudscapeProperties != null) {
            string = String.valueOf(string) + ";" + this.cloudscapeProperties;
        }
        return string;
    }
}

