/*
 * Decompiled with CFR 0.152.
 */
package COM.objectspace.jgl;

import COM.objectspace.jgl.BinaryPredicate;
import COM.objectspace.jgl.ForwardIterator;
import COM.objectspace.jgl.HashComparator;
import COM.objectspace.jgl.Sequence;

public final class Sorting {
    static final int stlThreshold = 16;
    Sequence base;
    BinaryPredicate comparator;

    private Sorting() {
    }

    public static void sort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        HashComparator hashComparator = new HashComparator();
        new Sorting(forwardIterator, forwardIterator2, hashComparator);
    }

    public static void sort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        new Sorting(forwardIterator, forwardIterator2, binaryPredicate);
    }

    public static void sort(Sequence sequence) {
        ForwardIterator forwardIterator = sequence.start();
        ForwardIterator forwardIterator2 = sequence.finish();
        HashComparator hashComparator = new HashComparator();
        new Sorting(forwardIterator, forwardIterator2, hashComparator);
    }

    public static void sort(Sequence sequence, BinaryPredicate binaryPredicate) {
        ForwardIterator forwardIterator = sequence.start();
        ForwardIterator forwardIterator2 = sequence.finish();
        new Sorting(forwardIterator, forwardIterator2, binaryPredicate);
    }

    private Sorting(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        if (!(forwardIterator.getContainer() instanceof Sequence) || !(forwardIterator2.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        this.base = (Sequence)forwardIterator.getContainer();
        this.comparator = binaryPredicate;
        int n2 = this.base.start().distance(forwardIterator);
        int n3 = this.base.start().distance(forwardIterator2);
        this.quickSortLoop(n2, n3);
        this.finalInsertionSort(n2, n3);
    }

    void finalInsertionSort(int n2, int n3) {
        if (n3 - n2 > 16) {
            int n4 = n2 + 16;
            int n5 = n2 + 1;
            while (n5 < n4) {
                this.linearInsert(n2, n5);
                ++n5;
            }
            int n6 = n4;
            while (n6 < n3) {
                this.unguardedLinearInsert(n6, this.base.at(n6));
                ++n6;
            }
            return;
        }
        int n7 = n2 + 1;
        while (n7 < n3) {
            this.linearInsert(n2, n7);
            ++n7;
        }
    }

    void unguardedLinearInsert(int n2, Object object) {
        int n3 = n2 - 1;
        while (this.comparator.execute(object, this.base.at(n3))) {
            this.base.put(n2--, this.base.at(n3--));
        }
        this.base.put(n2, object);
    }

    void linearInsert(int n2, int n3) {
        Object object = this.base.at(n3);
        if (this.comparator.execute(object, this.base.at(n2))) {
            int n4 = n3;
            while (n4 > n2) {
                this.base.put(n4, this.base.at(n4 - 1));
                --n4;
            }
            this.base.put(n2, object);
            return;
        }
        this.unguardedLinearInsert(n3, object);
    }

    void quickSortLoop(int n2, int n3) {
        while (n3 - n2 > 16) {
            Object object = this.base.at(n2);
            Object object2 = this.base.at(n2 + (n3 - n2) / 2);
            Object object3 = this.base.at(n3 - 1);
            Object object4 = this.comparator.execute(object, object2) ? (this.comparator.execute(object2, object3) ? object2 : (this.comparator.execute(object, object3) ? object3 : object)) : (this.comparator.execute(object, object3) ? object : (this.comparator.execute(object2, object3) ? object3 : object2));
            int n4 = n2;
            int n5 = n3;
            while (true) {
                if (this.comparator.execute(this.base.at(n4), object4)) {
                    ++n4;
                    continue;
                }
                --n5;
                while (this.comparator.execute(object4, this.base.at(n5))) {
                    --n5;
                }
                if (n4 >= n5) break;
                Object object5 = this.base.at(n4);
                this.base.put(n4++, this.base.at(n5));
                this.base.put(n5, object5);
            }
            if (n4 - n2 >= n3 - n4) {
                this.quickSortLoop(n4, n3);
                n3 = n4;
                continue;
            }
            this.quickSortLoop(n2, n4);
            n2 = n4;
        }
    }
}

