package examples.dbkona;

import weblogic.db.jdbc.*;
import weblogic.db.jdbc.oracle.*;
import java.sql.*;
import java.util.Properties;

/**
 * This class demonstrates using a dbKona Sequence object to create,
 * use, and drop an Oracle sequence. A dbKona Sequence object is a
 * wrapper for an Oracle sequence.
 * <p>
 * To run this example, you'll need an Oracle database.  The example
 * is executed from the command line and results are displayed to
 * standard out.
 *<p>The following section describes how to build and run the examples:
 * <p>
 * <ol>
 * <li><a href="#Build the example">Build the example</a>
 * <li><a href="#Configure the server">Configure the server</a>
 * <li><a href="#Run the example">Run the example</a>
 * </ol>
 * <h3><a name="Build the example">Build the example</a></h3>
 * <ol>
 * <li>Set up your development shell as described in <a
 * href=../examples.html#environment>Setting up your environment for building and running the examples</a>.
 * <p>
 * <li>Compile the example by executing an <font face="Courier New" size = -1>ant</font> 
 * build script or a command.
 * <p>
 * <ul>
 * <li>An <font face="Courier New" size = -1>ant</font> build script is available in the
 * <font face="Courier New" size = -1>samples/examples/dbkona</font> directory. Enter the following command
 * to execute the build script:
 * <p>
 * <pre><font face="Courier New"><b>ant</b></font>, or</pre>
 * <p>
 * <li>Enter the following command to compile the example:
 * <p>
 * <pre><font face="Courier New"><b>$ javac -d %CLIENT_CLASSES% sequences.java</b></font></pre>
 * </ol>
 * </ol>
 * <h3><a name="Configure the server">Configure the server</a></h3>
 * <ol>
 * <li><a href=../examples.html#startServer>Start the server with the examples configuration.</a>
 * <p><li>Bring up the Administration
 * Console in your browser with the URL:
 * <pre>http://<i>hostname</i>:<i>port</i>/console</pre>
 * where:
 * <dl>
 * <dt><i><font size=-1>hostname</font></i>
 * <dd>Host name of the WebLogic Server
 * <dt><i><font size=-1>port</font></i>
 * <dd>Port where the WebLogic Server is listening for connections
 * </dl>
 * <li>Click to expand the Services node in the left-hand pane.
 * <li>Click to expand the JDBC node in the left-hand pane.
 * <li>Click to expand the Connection Pools node in the left-hand pane.
 * <li>Select the oraclePool node.
 * <li>Select the Targets tab in the right-hand pane to display the Available and Chosen targets.
 * <li>Select the examplesServer target in the Available column.
 * <li>Click the mover control to move the examplesServer target to the Chosen column.
 * <li>Click the Apply button in the lower right-hand corner to save your assignment in the console configuration file.
 * </ol>
 * <h3><a name="Run the example"></a>Run the example</h3>
 * <ol>
 * <li>Run this example by executing the following command in your development shell:
 * <p>
 * <pre><font face="Courier New"><b>$ java examples.dbkona.sequences</b></font></pre>
 * </ol>
 *
 * @author       Copyright (c) 1996-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class sequences {

  /**
   * Here the JDBC connection is configured and made. Before we
   * attempt to create a new dbKona Sequence, which is always
   * used in context of the JDBC connection object, we first try
   * to drop a Sequence of the same name. Then the Sequence is
   * created and its next value is printed out in a loop from
   * 0 - 9. Finally the Sequence is dropped and closed, and the
   * JDBC connection is closed.
   */
  public static void main(String argv[]) {

    Connection conn = null;
    Sequence seq = null;

    try {
      // For more information on making a connection, see the
      // dbKona Developers Guide.
      Properties props = new Properties();
      props.put("user",     "scott");
      props.put("password", "tiger");
      props.put("server",   "DEMO");

      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.oci.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:oracle", props);


      // Drop the sequence from the server if it already exists.
      try {Sequence.drop(conn, "testseq");} catch (Exception e) {;}

      // Create a new sequence on the server. The first integer argument
      // is the increment, the second is the starting value.
      Sequence.create(conn, "testseq", 1, 1);

      seq = new Sequence(conn, "testseq");

      // Print out the next value in the sequence in a loop.
      for (int i = 0; i < 10; i++) {
	System.out.println(seq.nextValue());
      }

      System.out.println(seq.currentValue());
    } catch(Exception e) {
      System.err.println("Trouble while executing example");
      e.printStackTrace();
    } finally {
      // You should always close DataSets, ResultSets, and Statements
      // when you have finished working with them.
      try {
	seq.close();
      } catch (Exception e) {}

      // Drop the sequence from the server.
      try {
	Sequence.drop(conn, "testseq");
      } catch (Exception e) {
	System.err.println("Trouble removing sequence from DBMS");
	e.printStackTrace();
      }

      // Finally, close the connections.
      try {
	conn.close();
      } catch(Exception e) {}
    }
  }
}

