package examples.ejb.basic.statelessSession;

import java.io.Serializable;

/**
 * This class reflects the results of a buy/sell transaction.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public final class TradeResult implements Serializable {

  // Number of shares really bought or sold.
  private int    numberTraded; 

  private String stockSymbol;

  public TradeResult() {}

  public TradeResult(int nt, String ss) {
    numberTraded = nt;
    stockSymbol  = ss;
  }

  public int getNumberTraded() { return numberTraded; }
  public void setNumberTraded(int numberTraded) { this.numberTraded = numberTraded; }
  public String getStockSymbol() { return stockSymbol; }
  public void setStockSymbol(String stockSymbol) { this.stockSymbol = stockSymbol; }
}
