package examples.ejb.subclass;

import java.rmi.RemoteException;

/**
 * The methods in this interface are the public face of ChildBean.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * <p>
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, ChildBeanE, implements this interface and
 * delegates to the bean.
 * <p>
 * Note that the only method defined in this interface is the one unique to the
 * ChildBean. All other methods are inherited from the Parent interface.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Child extends Parent {

  /**
   * Sends back a pre-defined message identifying the method.
   * This method is unique to the Child bean.
   *
   * @return                  String Message
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public String childOnlyMethod()
    throws RemoteException;

}
