drop table fanclubs;

drop table recordings;

drop table artists;

drop table bands;

drop table band_artist; 

drop table artist_sequence;

create table bands (
   name varchar(50), 
   founder varchar(50), 
   startDate date, 
primary key (name, founder));

create table recordings (
   title varchar(50), 
   bandName varchar(50),
   bandFounder varchar(50), 
   numberSold INTEGER,
   sales NUMERIC(10, 2),
   recordingDate DATE,
primary key (title, bandName, bandFounder),
foreign key (bandName, bandFounder) references bands(name, founder));

create table fanclubs (
   text varchar(1024), 
   bandName varchar(50),
   bandFounder varchar(50),
   memberCount INTEGER, 
primary key (bandName, bandFounder),
foreign key (bandName, bandFounder) references bands(name, founder));

create table artists (
   name varchar(50), 
   id integer, 
primary key (id));

create table band_artist (
   band_name varchar(50),
   band_founder varchar(50),
   artist_id integer,
foreign key (band_name, band_founder) references bands(name, founder),
foreign key (artist_id) references artists(id)
);

create table artist_sequence (
   sequence integer
);

insert into artist_sequence values (1);
