package examples.ejb20.cascadeDelete.one2many;


import java.rmi.RemoteException;
import javax.ejb.*;


/**
 * The methods in this interface are the public face of AccountBean.
 * The signatures of the methods are identical to those of the bean,
 * except that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface.
 * The corresponding code-generated EJBObject implements this interface
 * and delegates to the EJBean.
 *
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Account extends EJBLocalObject {

  /**
   * Deposits an amount.
   *
   * @param amount            double Amount to deposit
   * @return                  double Account Balance
   */
  public double deposit(double amount);

  /**
   * Withdraws an amount.
   *
   * @param amount            double Amount to withdraw
   * @return                  double Account Balance
   * @exception               examples.ejb.basic.cmp20_OneToOne.ProcessingErrorException
   *                          if there is an error while depositing
   */
  public double withdraw(double amount);

  /**
   * Balance in account.
   *
   * @return                  double Account Balance
   */
  public double balance();

  /**
   * Type of account.
   *
   * @return                  String account Type
   */
  public String accountType();

  /**
   * Returns account ID.
   *
   * @return                  String account ID
   */
  public java.lang.String getAccountId();

  /**
   * Returns a customer.
   *
   * @return                  Customer name
   */
  public Customer getCustomer();

  public void setCustomer(Customer c);
  }














