package examples.ejb20.cascadeDelete.one2many;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.*;

/**
 * Interface for a customer bean. Demonstrates one to many
 * releationship with AccountBean.
 *
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Customer extends EJBLocalObject {

  /**
   * Returns name of customer.
   *
   * @return                  java.lang.String
   */
  public java.lang.String getName();

  /**
   * Adds Account.
   */
  public void addAccount(Account acct);

  /**
   * Returns serializable Collection of Accounts.
   *
   * @return                  Collection
   */
  public Collection getAllAccounts();

  /**
   * Return accounts.
   *
   * @return                  Collection
   */
  public Collection getAccounts();

  public void setAccounts(Collection accts);

}














