package examples.ejb20.cascadeDelete.one2many;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;


/**
 * Represents a customer and demonstrates one to many
 * releationship with AccountBean.
 *
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
abstract public class CustomerBean implements EntityBean {

  final static boolean VERBOSE = false;

  private EntityContext ctx;

  public CustomerBean() {}

  /**
   * Sets the EntityContext for the EJBean.
   *
   * @param ctx               EntityContext
   */
  public void setEntityContext(EntityContext ctx) {
    log("setEntityContext called (" + id() + ")");
    this.ctx = ctx;
  }

  /**
   * Unsets the EntityContext for the EJBean.
   *
   */
  public void unsetEntityContext() {
    log("CustomerBean.unsetEntityContext (" + id() + ")");
    this.ctx = null;
  }

  /**
   * container managed fields
   */
  abstract public java.lang.String getName();
  abstract public void setName(java.lang.String val);

  abstract public int getAge();
  abstract public void setAge(int val);

  abstract public Integer getLevelOfImportance();
  abstract public void setLevelOfImportance(Integer val);

  abstract public java.sql.Date getLastContact();
  abstract public void setLastContact(java.sql.Date val);

  abstract public Collection getAccounts();
  abstract public void setAccounts(Collection accts);

  /**
   * Adds Account.
   *
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public void addAccount(Account acct)
  {
    log("CustomerBean.addAccounts");

    Collection accts = getAccounts();
    accts.add(acct);
  }

  /**
   * Returns serializable Collection of Accounts.
   *
   * @return                  Collection
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public Collection getAllAccounts()
  {
    log("CustomerBean.getAllAccounts");
    List returnList = new ArrayList();

    Collection accts = getAccounts();
    Iterator iter = accts.iterator();
    log("accounts------------------------------");
    while (iter.hasNext()) {
      Object ob = iter.next();
      log(ob.getClass().getName());
      returnList.add(ob);
    }

    return returnList;
  }

  /**
   */
  private String id() {
    return "" + System.identityHashCode(this) + ", PK = " +
      (String) ((ctx == null) ? "nullctx"
                 : ((ctx.getPrimaryKey() == null ?
                   "null" : ctx.getPrimaryKey().toString())));
  }

  /**
   */
  public void ejbActivate() {
      log("CustomerBean.ejbActivate (" + id() + ")");
  }

  /**
   */
  public void ejbPassivate() {
    log("CustomerBean.ejbPassivate (" + id() + ")");
  }

  /**
   */
  public void ejbLoad() {
    log("CustomerBean.ejbLoad (" + id() +  ")");
  }

  /**
   */
  public void ejbStore() {
    log("CustomerBean.ejbStore (" + id() + ")");
  }

  /**
   */
  public void ejbRemove()
    throws RemoveException
  {
    log("CustomerBean.ejbRemove (" + id() + ")");
  }

  /**
   */
  public String ejbCreate(String name, int age, Integer level, java.sql.Date lastDate)
    throws CreateException
  {
    log("CustomerBean.ejbCreate( id = " + System.identityHashCode(this) +
        ", PK = " + name + ")");

    setName(name);
    setAge(age);
    setLevelOfImportance(level);
    setLastContact(lastDate);

    return null;  // See 9.4.2 of the EJB 1.1 specification
  }

  /**
   */
  public void ejbPostCreate(String name, int age, Integer level, java.sql.Date lastDate)
    throws CreateException
  {
    log("CustomerBean.ejbPostCreate (" + id() + ")");

  }

  // You might also consider using WebLogic's log service
  private void log(String s) {
    if (VERBOSE) System.out.println(s);
  }
}














