package examples.ejb20.homeMethods;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/**
 * This class demonstrates calling a home method on an Entity bean.
 * <p>
 * <p>
 * This class also illustrates how to lookup an EJB home in the JNDI tree. 
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class Client {

  private String m_url;
  
  private AccountHome m_home;

  public Client(String url)
    throws NamingException
  {
    m_url = url;
    
    m_home = lookupHome();
  }

  /**
   * Runs this example from the command line. Example:
   * <p>
   * <tt>java examples.ejb20.homeMethods.Client "t3://localhost:7001"</tt>
   * <p>
   * The parameters are optional, but if any are supplied,
   * they are interpreted in this order:
   * <p>
   * @param url               URL such as "t3://localhost:7001" of Server
   */
  public static void main(String[] args) throws NamingException {
    System.out.println("\nBeginning ejb20.examples.homeMethods.Client...\n");

    String url       = "t3://localhost:7001";
    
     
    // Parse the argument list 
     if (args.length != 1) {
      System.out.println("Usage: java examples.ejb20.homeMethods.Client t3://hostname:port");   
      return;
    } else {
      url = args[0];
    }

    
    Client client = null;

    try {
      client = new Client(url);
    } catch (NamingException ne) {
      ne.printStackTrace();
      log("Unable to look up the beans home: " + ne.getMessage());
      System.exit(1);
    }

    try {
      client.example();

    } catch (Exception e) {
      log("There was an exception while creating and using the Accounts.");
      log("This indicates that there was a problem communicating with the server: "+e);
    } 

    System.out.println("\nEnd ejb20.examples.homeMethods.Client...\n");
  }
     

  public void example() throws RemoteException, NamingException {
    String message = m_home.homyMethod();
    System.out.println("\n\n  Here is the message from the remote invocation of the Home Method homyMethod: '"+
		       message+"'\n\n");
  }

  /**
   * Look up the bean's home interface using JNDI.
   */
  private AccountHome lookupHome()
    throws NamingException
  {
    Context ctx = getInitialContext();
   
    try {
      Object home = ctx.lookup("homeMethods.AccountHome");
      return (AccountHome) PortableRemoteObject.narrow(home, AccountHome.class);

    } catch (NamingException ne) {
      log("The client was unable to lookup the EJBHome.  Please make sure " +
      "that you have deployed the ejb with the JNDI name " + 
      "homeMethods.AccountHome on the WebLogic server at "+m_url);

      throw ne;
    }
  }

  /**
   * Get an initial context into the JNDI tree.
   *
   * Java2 clients can use the jndi.properties file to set the
   * INITIAL_CONTEXT_FACTORY and the PROVIDER_URL
   *  private Context getInitialContext() throws NamingException {
   *    return new InitialContext();
   *  }
   *
   *
   * Using a Properties object will work on JDK 1.1.x and Java2
   * clients
   */
  private Context getInitialContext() throws NamingException {
    
    try {
      // Get an InitialContext
      Properties h = new Properties();
      h.put(Context.INITIAL_CONTEXT_FACTORY,
        "weblogic.jndi.WLInitialContextFactory");
      h.put(Context.PROVIDER_URL, m_url);
      return new InitialContext(h);
    } catch (NamingException ne) {
      log("We were unable to get a connection to the WebLogic server at "+m_url);
      log("Please make sure that the server is running.");
      throw ne;
    }
  }

  private static void log(String s) {
    System.out.println(s);
  }
}
