package examples.i18n.logging.message;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

/**
 * <p>UserSMessagesServlet is a simple servlet which shows how to use
 * WebLogic i18n to log your own application's info and error messages
 * to the server log. There is a similar example showing how to do the
 * same thing from a startup class instead of a servlet.
 *
 * <p>After running the example once, change your host computer's locale
 * from "English" to "German" or "French" and reboot the WebLogic server. Run the example
 * again and note that the example's log messages are displayed in either "German" or "French"
 * depending upon your settings.
 * <p>
 * The following section describes how to build and run the examples:
 * <ol>
 * <li><a href="#Build the example">Build the example</a>
 * <li><a href="#Configure the server">Configure the server</a> 
 * <li><a href="#Run the example">Run the example</a>
 * </ol>
 * <p>
 * <b>Note:</b> Before you build the example add the following entry in your web.xml file located at <tt>%WL_HOME%/config/examples/applications/examplesWebApp/WEB-INF/</tt>
 * directory.
 * <p>
 * where:
 * <dl>
 * <dt><i><font face="Courier New" size = -1><b>%WL_HOME%</b></font></i>
 * <dd>WebLogic Server installation directory.
 * </dl>
 * <pre>
 *   &lt;servlet&gt;
 *     &lt;servlet-name&gt;UserSMessagesServlet&lt;/servlet-name&gt;
 *     &lt;servlet-class&gt;examples.i18n.logging.message.UserSMessagesServlet&lt;/servlet-class&gt;
 *   &lt;/servlet&gt;
 *   &lt;servlet-mapping&gt;
 *     &lt;servlet-name&gt;UserSMessagesServlet&lt;/servlet-name&gt;
 *     &lt;url-pattern&gt;/UserSMessagesServlet/*&lt;/url-pattern&gt;
 *   &lt;/servlet-mapping&gt;
 * </pre>
 * 
 * <h3><a name="Build the example">Build the example</a></h3>
 * <ol>
 * <li>Set up your development shell as described in 
 * <a href=../../examples.html#environment>Setting up your environment</a>.
 * <p>We provide a build script for you to build the example, called <b><a href="build.xml">build.xml</a></b>.
 * <li>Run the build script using the following Java  ant command:
 * <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <font face="Courier New,Courier"><font size=-1>$
 * ant</font></font></li>
 * <p>The script builds the example and places the files in the
 * samples\examples\i18n\logging directory of your WebLogic Server installation.</ol>
 * <p>This script will compile the servlet, process the <b>UserServerSVExample.xml</b> catalog, and produce the logging class.
 * This class contains static methods for logging messages to the WebLogic Server error log.
 * </ol>
 * <h3><a name="Configure the server">Configure the server</a></h3>
 * <ol>
 * <li>Make sure that the <font face="Courier New" size=-1><a href=../../examples.html#webApp>examplesWebApp</a></font> is deployed on your server.
 * </ol>
 * <h3><a name="Run the example">Run the example</a></h3>
 * <ol>
 * <li><a href=../../examples.html#startServer>Start the WebLogic Server with the examples configuration</a>.
 * <p><li>Use a web browser to load the following URL:
 * <pre><b>http://localhost:7001/examplesWebApp/UserSMessagesServlet</b></pre>
 * <p><li>You should receive output similar to this in your <font face="Courier New" size=-1>weblogic.log</font> file:
 * <pre><font face="Courier New">
 * First message was logged at 1/5/01.
 * The servlet request was a GET and the number is 32,767.
 * This is not really an error, the example has finished normally.
 * </font></pre>
 * </ol>
 * <p>
 * Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class UserSMessagesServlet extends HttpServlet {

 /**
   * service() method.
   * @param req	HTTP servlet request
   * @param res	HTTP servlet response
   * @exception IOException if problem occurs with an I/O operation
   * @exception ServletException if problem occurs with servlet operation
  */

  public void service(HttpServletRequest req, HttpServletResponse res)
       throws IOException, ServletException
  {
    // Must set the content type first
    res.setContentType("text/html");
    // Now we can obtain a PrintWriter
    PrintWriter pw = res.getWriter();

    pw.println("<html><head><title>UserSMessagesServlet</title></head>");
    pw.println("<body><h1>");
    pw.println("Will now cause user messages to be written to the server log");
    pw.println("</h1><p>");

    // The UserServerSVExampleLogger.class is generated by the invocation
    // of weblogic.i18ngen in the script build_servlet.sh or build_servlet.cmd

    Date nowD = new Date();
    String msgid = UserServerSVExampleLogger.logFirstMessage(nowD);

    pw.println("<p>Message " + msgid + " was logged.");

    String httpMeth = req.getMethod();
    msgid = UserServerSVExampleLogger.logMoreStuff(httpMeth, 0x7FFF);

    pw.println("<p>Message " + msgid + " was logged.");

    UserServerSVExampleLogger.logDone();

    nowD = new Date();
    pw.println("<p>The last message was logged at " + nowD + ".</body></html>");
    // Do not close the output stream or print writer.
  }
}
