package examples.i18n.logging.startup;

import javax.naming.*;
import java.util.Hashtable;

/**
 * <p>UserSMessagesStartClient is used to exercise UserSMessagesStartupImpl
 * which runs on the server.
 * 
 * <p>UserSMessagesStartupImpl is a simple startup class which shows how to use
 * WebLogic i18n to log your own application's info and error messages
 * to the server log. There is a similar example showing how to do the
 * same thing from a servlet instead of a startup class.
 *
 * <p>
 * @author Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class UserSMessagesStartClient
{
  /**
   * Defines the JNDI context factory.
   */
  public final static String JNDI_FACTORY="weblogic.jndi.WLInitialContextFactory";

  public static void main(String args[])
  {
    if (args.length != 2) {
      System.out.println("Usage:  UserSMessagesStartClient  host  port");
      System.exit(0);
    }
    String hostName = args[0];
    String portStr  = args[1];
    String providerUrl = "t3://" + hostName + ":" + portStr;

    Context contx = null;
    UserSMessagesStartup usmStar = null;
    String action = "make new Hashtable";
    try {
      //  Get a context from the server:
      Hashtable env = new Hashtable();
      action = "set Provider Url";
      env.put(Context.PROVIDER_URL, providerUrl);
      action = "set Context Factory";
      env.put(Context.INITIAL_CONTEXT_FACTORY, JNDI_FACTORY);
      action = "call env.getInitialContext()";
      contx = new InitialContext(env);

      //  Lookup the desired startup class:
      action = "lookup " + UserSMessagesStartup.USSNAME;
      usmStar = (UserSMessagesStartup) contx.lookup(UserSMessagesStartup.USSNAME);

      //  Make sure we got what we think we got.
      //  This virtually never fails, so call me paranoid!
      action = "call UserSMessagesStartup.verifyMCode()";
      int magicN = usmStar.verifyMCode();
      if (magicN != UserSMessagesStartup.MAGIC_NUMBER) {
        action = "verify correct return value from UserSMessagesStartup";
        throw new Exception("expected " + UserSMessagesStartup.MAGIC_NUMBER +
                            " but got " + magicN);
      }

      //  Now do what we came here for:
      //  Cause user messages to be sent to the server log (and server stdout).
      action = "call UserSMessagesStartup.issueLogMessages()";
      usmStar.issueLogMessages();

      System.out.println("The UserSMessagesStartClient has completed successfully.");
      System.out.println("Check the server log for the expected messages in the expected language!");
    }
    catch (Exception ce) {
      System.out.println("FAILED to demonstrate i18n log messages, could not " +
                         action + ", " + ce);
    }
    finally {
      if (contx != null) {
        try {
          contx.close();
        }
        catch (NamingException ne) {
          System.out.println("WARNING: could not close context, " + ne);
        }
      }
    }
  }
}
