package examples.i18n.logging.startup;

import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.T3ServicesDef;
import weblogic.common.T3StartupDef;
import weblogic.common.T3ShutdownDef;
import weblogic.jndi.Environment;
import weblogic.rmi.Naming;

/**
 * <p>UserSMessagesStartupImpl is a simple startup class which shows how to
 * use WebLogic i18n to log your own application's info and error messages
 * to the server log. There is a similar example showing how to do the
 * same thing from a servlet instead of a startup class.
 *
 * <p>You exercise this example with the java client: UserSMessagesStartClient
 *
 * <p>After running the example once, change your host computer's locale
 * from "English" to "German" or "French" and reboot the WebLogic server. Run the example
 * again and note that the example's log messages are displayed in either "German" or "French"
 * depending upon your settings.
 * <p>
 * @author Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class UserSMessagesStartupImpl implements UserSMessagesStartup,
                                                 T3StartupDef, T3ShutdownDef
{
  private T3ServicesDef  uss_services;

  public UserSMessagesStartupImpl()  throws RemoteException
  {
    super();                           //  java.rmi.Remote
  }

  public void setServices(T3ServicesDef services)
  {
    //  Part of T3StartupDef interface,
    //  setServices called by Weblogic Server when object is launched,
    //  before the startup() method.
    uss_services = services;
  }

  public String startup(String name, java.util.Hashtable unused_ht)  throws Exception
  {
    //  startup() is part of T3StartupDef interface.

    //  Clients expect to know the name we bind to.  They get it from USSNAME:
    if (! USSNAME.equals(name)) {
      System.out.println("WARNING: Will not bind to " + name + " but rather will bind to " + USSNAME);
      name = USSNAME;
    }
    
    //  Bind into JNDI:
    Context contx = null;
    String result = null;
    String action = "get initial context";
    try {
      contx = new InitialContext();
      action = "bind " + name;
      contx.bind(name, this);

      result = "The UserSMessagesStartupImpl object is now in the JNDI registry as " + name;
    }
    catch (Exception ce) {
      System.out.println("ERROR:  Could not startup " + name +
          " for demonstrating i18n log messages.\n" +
          "        More specifically, could not " + action + "\n" +
          "        " + ce);
      result = "FAILURE: could not startup " + name + ", failed to " + action;
    }
    finally {
      if (contx != null) {
        try {
          contx.close();
        }
        catch (NamingException ne) {
          System.out.println("WARNING: could not close context, " + ne);
        }
      }
    }
    return result;
  }

  public String shutdown(String name, java.util.Hashtable dontCare)  throws Exception
  {
    return("UserSMessagesStartup (" + name + ") has been informed of server shutdown");
  }

  public int verifyMCode()  throws RemoteException
  {
    return MAGIC_NUMBER;
  }

  public void issueLogMessages()  throws RemoteException
  {
    //  This will go to the server command shell console but not to the log:
    System.out.println("********************Will now cause user messages to be written to the server log");

    //  The UserServerSCExampleLogger.class is generated by the invocation
    //  of weblogic.i18ngen in the script build_startup.cmd or build_startup.sh

    UserServerSCExampleLogger.logInitialMessage(17);

    UserServerSCExampleLogger.logStringAndPrevCallCount("ABCD", 0);
    UserServerSCExampleLogger.logStringAndPrevCallCount("QRSTUV", 1);
    UserServerSCExampleLogger.logStringAndPrevCallCount("WXYZ", 2);

    String msgid = UserServerSCExampleLogger.logFinalMessage();

    System.out.println("********************The last example message ID was " + msgid);
  }
}
