#include "CosNaming_c.hh"

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include "client_c.hh"

#define BASIC_VALUETYPE(name,package)					\
class name##Impl : public virtual package##::OBV_##name,			\
		   public virtual CORBA::DefaultValueRefCountBase	\
{									\
public:									\
  name##Impl () {}							\
  ~##name##Impl () {}							\
  CORBA_ValueBase* _copy_value() {					\
    return new name##Impl();						\
  }									\
  friend class name##Helper; \
};									\
									\
class name##Factory : public package##::##name##_init			\
{									\
public:									\
  name##Factory () {}							\
  ~##name##Factory () {}						\
  CORBA::ValueBase*  create_for_unmarshal() 				\
  {									\
    return new name##Impl(); 						\
  }									\
}

#define BASIC_VALUETYPE_FACTORY(name,package,impl)		\
class name##Factory : public package##::##name##_init			\
{									\
public:									\
  name##Factory () {}							\
  ~##name##Factory () {}						\
  CORBA::ValueBase*  create_for_unmarshal() 				\
  {									\
    return new impl(); 						\
  }									\
}

BASIC_VALUETYPE(RemoveException,::javax::ejb);
BASIC_VALUETYPE(FinderException,::javax::ejb);
BASIC_VALUETYPE(ObjectNotFoundException,::javax::ejb);
BASIC_VALUETYPE(ProcessingErrorException,
		::examples::iiop::ejb::entity::server::wls);

class FinderEnumeration : public virtual ::weblogic::ejb::OBV_EJBObjectEnum,
                                 public virtual CORBA::DefaultValueRefCountBase
{								
  public:
  FinderEnumeration () {}
  ~FinderEnumeration () {}
  CORBA_ValueBase* _copy_value() {
    return new FinderEnumeration();
  }
  ::java::util::Vector_ptr elements() const 
  {
    return v();
  }
};

// 
// This class partly implements the java.util.Vector API.
//
class Vector : public virtual ::java::util::OBV_Vector,
                      public virtual CORBA::DefaultValueRefCountBase
{								
  public:
  Vector () {}
  ~Vector () {}
  CORBA_ValueBase* _copy_value() {
    return new Vector();
  }
  const CORBA::Long size() const 
  { 
    return elementCount(); 
  }

  void setSize(const CORBA::Long sz)
  { 
    elementCount(sz); 
    capacityIncrement(0L);
    ::org::omg::boxedRMI::java::lang::seq1__Object_ptr seq =
	new ::org::omg::boxedRMI::java::lang::seq1__Object(sz);
    seq->length(sz);
    elementData(seq);
  }

  CORBA::Any& elementAt(CORBA::Long i) const
  { 
    return (*elementData())[i];  
  }
};

BASIC_VALUETYPE_FACTORY(EJBObjectEnum, ::weblogic::ejb,
                        FinderEnumeration);
BASIC_VALUETYPE_FACTORY(Vector, ::java::util, Vector);

int main(int argc, char* const* argv)
{
  try {
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

    // string to object
    CORBA::Object_ptr o;

    cout << "Getting name service reference" << endl;
    if (argc >= 2 && strncmp (argv[1], "IOR", 3) == 0)
      o = orb->string_to_object(argv[1]);
    else
      o = orb->resolve_initial_references("NameService");

    // Disgustingly we have to register valuetype factories for all the exceptions
    // we use.
    orb->register_value_factory("RMI:javax.ejb.FinderException:FD98A9711F66DF7F:79EE1514C8B7CA15", (CORBA::ValueFactory)new FinderExceptionFactory);
    orb->register_value_factory("RMI:javax.ejb.ObjectNotFoundException:5E2415FE96422431:00106DD5ADF01DDA", (CORBA::ValueFactory)new ObjectNotFoundExceptionFactory);
    orb->register_value_factory("RMI:javax.ejb.RemoveException:FD98A9711F66DF7F:C06A008FD05A462A", (CORBA::ValueFactory)new RemoveExceptionFactory);
    orb->register_value_factory("RMI:weblogic.ejb.EJBObjectEnum:F75CF1075F12B574:250FA3B2514485F0", (CORBA::ValueFactory)new EJBObjectEnumFactory);
    orb->register_value_factory("RMI:java.util.Vector:62E909C46C1937A3:D9977D5B803BAF01", (CORBA::ValueFactory)new VectorFactory);
    orb->register_value_factory("RMI:[Ljava.lang.Object;:0000000000000000", (CORBA::ValueFactory)new ::org::omg::boxedRMI::java::lang::seq1__Object_factory);

    // obtain a naming context
    cout << "Narrowing to a naming context" << endl;
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup("AccountHome_iiop");
    name[0].kind = CORBA::string_dup("");

    // resolve and narrow to RMI object
    cout << "Resolving the naming context" << endl;
    CORBA::Object_var object = context->resolve(name);

    cout << "Narrowing to the AccountHome" << endl;
    examples::iiop::ejb::entity::server::wls::AccountHome_var home =
      examples::iiop::ejb::entity::server::wls::AccountHome::_narrow(object);

    int numBeans = 7;
    examples::iiop::ejb::entity::server::wls::Account_ptr accounts[7];

    // Create 7 accounts with varying balances and some null accountTypes.
    cout << "Creating accounts ...." << endl;
    for (int i=0; i<numBeans; i++) {
      char buffer[10];
      sprintf(buffer, "ID%d", i);
      wchar_t wbuf[10];
      mbstowcs(wbuf, buffer, 10);
      ::CORBA::WStringValue* id = new ::CORBA::WStringValue((const wchar_t*)wbuf);

      try {
	cout << " Finding account " << i << " ...";
	accounts[i] = examples::iiop::ejb::entity::server::wls::Account::_narrow
	  (home->findByPrimaryKey(id));
      } catch (const ::javax::ejb::ObjectNotFoundEx& e) {
	cout << "failed, creating ...";
	::CORBA::WStringValue* type = new ::CORBA::WStringValue(L"Savings");
	// the account id does not yet exist so create it.
	accounts[i] = examples::iiop::ejb::entity::server::wls::Account::_narrow
	  (home->create(id, i * 1000, type));
	type->_remove_ref();
      }
      id->_remove_ref();
      cout << "done" << endl;
    }

    // print out the account balances
    for (i=0; i<numBeans; i++) {
      cout << "Account: :" << accounts[i]->primaryKey() <<
	" has a balance of "<< accounts[i]->balance() << endl;
    }

    cout << "Creating and marshalling a Vector" << endl;
    Vector* vin = new Vector();
    vin->setSize(2);
    vin->elementAt(0) <<= new ::CORBA::WStringValue(CORBA::wstring_dup(L"hello"));
    vin->elementAt(1) <<= new ::CORBA::WStringValue(CORBA::wstring_dup(L"hi"));
    
    ::java::util::List_ptr list = accounts[0]->test_seq(vin);

    cout << "Finding big accounts ..." << endl;
    // find all accounts with a balance > 5000
    ::java::util::Enumeration_ptr en = 
	home->findBigAccounts(5000.0);
    
    ::weblogic::ejb::EJBObjectEnum_ptr e
        = ::weblogic::ejb::EJBObjectEnum::_downcast(en);

    FinderEnumeration* fe = dynamic_cast<FinderEnumeration*>(e);
    Vector* v = dynamic_cast<Vector*>(fe->elements());
    
    if(v->size() <= 0) {
      cout << "No accounts were found!" << endl;
    }
    
    for (i=0; i<v->size(); i++) {
      CORBA::Object_ptr theNext;
      v->elementAt(i) >>= theNext;
      examples::iiop::ejb::entity::server::wls::Account_ptr bigAccount =
	examples::iiop::ejb::entity::server::wls::Account::_narrow(theNext);
      
      cout << "Account " << bigAccount->primaryKey() <<  
	"; balance is $" << bigAccount->balance() << endl;
    }

    // Remove our accounts
    cout << "Removing beans..." << endl;
    for (i=0; i<numBeans; i++) {
      accounts[i]->remove();
    }
  } catch(const CORBA::Exception& e) {
    cout << "Failure: " << e << endl;
  }
  return 0;
}
  

