#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include "CosNaming_c.h"

#include "AccountHome_c.h"
#include "RemoveException_i.h"
#include "ObjectNotFoundException_i.h"
#include "FinderException_i.h"
#include "ProcessingErrorException_i.h"
#include "EJBObjectEnum_i.h"
#include "Vector_i.h"
#include "ArrayList_i.h"
#include "seq1__Object_i.h"

int main(int argc, char** argv)
{
  try {
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

    // string to object
    CORBA::Object_ptr o;

    cout << "Getting name service reference" << endl;
    if (argc >= 2 && strncmp (argv[1], "IOR", 3) == 0)
      o = orb->string_to_object(argv[1]);
    else
      o = orb->resolve_initial_references("NameService");

    // Disgustingly we have to register valuetype factories for all the exceptions
    // we use.
    orb->register_value_factory
      ((char* const)javax::ejb::_tc_FinderException->id(), (CORBA::ValueFactory)
       new javax_ejb_FinderException_factory());
    orb->register_value_factory
      ((char* const)javax::ejb::_tc_RemoveException->id(), (CORBA::ValueFactory)
       new javax_ejb_RemoveException_factory());
    orb->register_value_factory
      ((char* const)javax::ejb::_tc_ObjectNotFoundException->id(), (CORBA::ValueFactory)
       new javax_ejb_ObjectNotFoundException_factory());
    orb->register_value_factory
      ((char* const)weblogic::ejb::_tc_EJBObjectEnum->id(), (CORBA::ValueFactory)
       new weblogic_ejb_EJBObjectEnum_factory());
    orb->register_value_factory
      ((char* const)java::util::_tc_Vector->id(), (CORBA::ValueFactory) 
       new java_util_Vector_factory());
    orb->register_value_factory
      ((char* const)java::util::_tc_ArrayList->id(), (CORBA::ValueFactory) 
       new java_util_ArrayList_factory());
    orb->register_value_factory
      ((char* const)org::omg::boxedRMI::java::lang::_tc_seq1__Object->id(),
       (CORBA::ValueFactory)new ::org::omg::boxedRMI::java::lang::seq1__Object_init);

    // obtain a naming context
    cout << "Narrowing to a naming context" << endl;
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup("AccountHome_iiop");
    name[0].kind = CORBA::string_dup("");

    // resolve and narrow to RMI object
    cout << "Resolving the naming context" << endl;
    CORBA::Object_var object = context->resolve(name);

    cout << "Narrowing to the AccountHome" << endl;
    examples::iiop::ejb::entity::server::wls::AccountHome_var home =
      examples::iiop::ejb::entity::server::wls::AccountHome::_narrow(object);

    int numBeans = 7;
    int i = 0;
    examples::iiop::ejb::entity::server::wls::Account_ptr accounts[7];

    // Create 7 accounts with varying balances and some null accountTypes.
    cout << "Creating accounts ...." << endl;
    for (i=0; i<numBeans; i++) {
      char buffer[10];
      sprintf(buffer, "MYID%d", i);
      wchar_t wbuf[10];
      mbstowcs(wbuf, buffer, 10);
      ::CORBA::WStringValue* id = new ::CORBA::WStringValue((const wchar_t*)wbuf);

      try {
	cout << " Finding account " << i << " ...";
	accounts[i] = examples::iiop::ejb::entity::server::wls::Account::_narrow
	  (home->findByPrimaryKey(id));
      } catch (const ::javax::ejb::ObjectNotFoundEx& e) {
        // This demonstrates the use of valuetype exceptions
	cout << "failed, creating ...";
	::CORBA::WStringValue* type = new ::CORBA::WStringValue(CORBA::wstring_dup(L"Savings"));
	// the account id does not yet exist so create it.
	accounts[i] = examples::iiop::ejb::entity::server::wls::Account::_narrow
	  (home->create(id, i * 1000, type));
	type->_remove_ref();
      }
      id->_remove_ref();
      cout << "done" << endl;
    }

    // print out the account balances
    for (i=0; i<numBeans; i++) {
      cout << "Account: :" << accounts[i]->primaryKey() <<
	" has a balance of "<< accounts[i]->balance() << endl;
    }

    // Send a vector. This demonstrates the construction of a
    // java-style valuetype.
    cout << "Creating and marshalling a Vector" << endl;
    java_util_Vector_i* vin = new java_util_Vector_i();
    vin->setSize(2);
    vin->elementAt(0) <<= new ::CORBA::WStringValue(CORBA::wstring_dup(L"hello"));
    vin->elementAt(1) <<= new ::CORBA::WStringValue(CORBA::wstring_dup(L"hi"));
    
    ::java::util::List_ptr list = accounts[0]->test_seq(vin);

    // Find all accounts. This demonstrates the use of a custom
    // valuetype (ArrayList) for returning a Collection-style finder.
    cout << "Finding all accounts ..." << endl;
    ::java::util::Collection_ptr listp = home->findAllAccounts();
    ::java::util::ArrayList_ptr alistp = ::java::util::ArrayList::_downcast(listp);
    ::java_util_ArrayList_i* ilistp = dynamic_cast<java_util_ArrayList_i*>(alistp);
    
    if(ilistp->size() <= 0) {
      cout << "No accounts were found!" << endl;
    }
    
    for (i=0; i<ilistp->size(); i++) {
      CORBA::Object_ptr theNext;
      cout << "Extracting element " << i << " ..." << endl;
      ilistp->elementAt(i) >>= theNext;
      cout << "Done" << endl;
      examples::iiop::ejb::entity::server::wls::Account_ptr bigAccount =
	examples::iiop::ejb::entity::server::wls::Account::_narrow(theNext);
      cout << "Account " << bigAccount->primaryKey() <<  
 	"; balance is $" << bigAccount->balance() << endl;
    }

    // Find big accounts. This demonstrates the use of a standard
    // valuetype (EJBObjectEnum) for returning an Enumeration-style
    // finder.
    cout << "Finding big accounts ..." << endl;
    // find all accounts with a balance > 5000
    ::java::util::Enumeration_ptr en = 
	home->findBigAccounts(5000.0);
    ::weblogic::ejb::EJBObjectEnum_ptr e
        = ::weblogic::ejb::EJBObjectEnum::_downcast(en);

    weblogic_ejb_EJBObjectEnum_i* fe = dynamic_cast<weblogic_ejb_EJBObjectEnum_i*>(e);
    java_util_Vector_i* v = dynamic_cast<java_util_Vector_i*>(fe->elements());
    
    if(v->size() <= 0) {
      cout << "No accounts were found!" << endl;
    }
    
    for (i=0; i<v->size(); i++) {
      CORBA::Object_ptr theNext;
      cout << "Extracting element " << i << " ..." << endl;
      v->elementAt(i) >>= theNext;
      cout << "Done" << endl;
      examples::iiop::ejb::entity::server::wls::Account_ptr bigAccount =
	examples::iiop::ejb::entity::server::wls::Account::_narrow(theNext);
      cout << "Account " << bigAccount->primaryKey() <<  
 	"; balance is $" << bigAccount->balance() << endl;
    }

    // Remove our accounts
    cout << "Removing beans..." << endl;
    for (i=0; i<numBeans; i++) {
      accounts[i]->remove();
    }
  } catch(const CORBA::Exception& e) {
    cout << "Failed" << endl;
  }
  return 0;
}


