#include <string>
#include <iostream>
#include "CosNaming_c.h"
#include "TraderHome_c.h"
#include "TradeResult_i.h"

using namespace std;

int main(int argc, char** argv)
{
  CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

  // string to object
  CORBA::Object_ptr o;
  int remote = CORBA_FALSE;
  
  cout << "Getting name service reference" << endl;
  if (argc >= 2 && strncmp (argv[1], "IOR", 3) == 0)
    o = orb->string_to_object(argv[1]);
  else
    o = orb->resolve_initial_references("NameService");
  
  for (int s = 0; s<argc; s++)
    if (strcmp(argv[s], "true")==0)
      remote = CORBA_TRUE;

  orb->register_value_factory
    ((char* const)examples::iiop::ejb::stateless::server::wls::_tc_TradeResult->id(), (CORBA::ValueFactory)
     new examples_iiop_ejb_stateless_server_wls_TradeResult_factory());
  
  // obtain a naming context
  cout << "Narrowing to a naming context" << endl;
  CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
  CosNaming::Name name;
  name.length(1);
  name[0].id = CORBA::string_dup("TraderHome_iiop");
  name[0].kind = CORBA::string_dup("");
  
  // resolve and narrow to RMI object
  cout << "Resolving the naming context" << endl;
  CORBA::Object_var object = context->resolve(name);

  cout << "Narrowing to the TraderHome" << endl;
  examples::iiop::ejb::stateless::server::wls::TraderHome_var home =
    examples::iiop::ejb::stateless::server::wls::TraderHome::_narrow(object);
  examples::iiop::ejb::stateless::server::wls::Trader_ptr bean = home->create();

  CORBA::WChar* stocks[]={L"BEAS", L"MSFT", L"AMZN", L"HWP", 0};
  for (int i=0; i<4; i++) {
    int shares = (i+1) * 100;
    cout << "Buying " << shares << " shares of " << (char*)stocks[i] << endl;
    ::CORBA::WStringValue* vl = new ::CORBA::WStringValue(CORBA::wstring_dup(stocks[i]));
    examples::iiop::ejb::stateless::server::wls::TradeResult_var tr = bean->buy(vl, shares);
    cout << "Bought " << tr->numberTraded() << " shares of " <<
      (char*)(tr->stockSymbol()->_value()) << endl;
    
    if (remote) {
      cout << "Buying remotely" << shares << " shares of " << (char*)stocks[i] << endl;
      examples::iiop::ejb::stateless::server::wls::TradeResult_var tr = bean->buyRemote(vl, shares);
      cout << "Bought " << tr->numberTraded() << " shares of " <<
        (char*)(tr->stockSymbol()->_value()) << endl;
    }
    vl->_remove_ref();
  }
  return 0;
}

