#ifdef VISIBROKER
#include "CosNaming_c.hh"
#include "client_c.hh"
#else
#include "CosNaming_c.h"
#include "client_c.h"
#endif
#include <iostream>

#ifndef VISIBROKER
using namespace std;
#endif

int main(int argc, char** argv)
{
  try {
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

    // string to object
    CORBA::Object_ptr o;
    int remote = 0;

    cout << "Getting name service reference" << endl;
    if (argc >= 2 && strncmp (argv[1], "IOR", 3) == 0)
      o = orb->string_to_object(argv[1]);
    else
      o = orb->resolve_initial_references("NameService");

    for (int i = 0; i<argc; i++)
      {
	if (strcmp(argv[i], "true") == 0)
	  remote = 1;
      }
    // obtain a naming context
    cout << "Narrowing to a naming context" << endl;
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup("Pinger_iiop");
    name[0].kind = CORBA::string_dup("");

    // resolve and narrow to RMI object
    cout << "Resolving the naming context" << endl;
    CORBA::Object_var object = context->resolve(name);

    cout << "Narrowing to the Ping Server" << endl;
    ::examples::iiop::rmi::server::wls::Pinger_var ping =
      ::examples::iiop::rmi::server::wls::Pinger::_narrow(object);
    
    // ping it
    cout << "Ping (local) ..." << endl;
    ping->ping();
    if (remote)
      {
	cout << "Ping (remote) ..." << endl;
	ping->pingRemote();
      }
  }
  catch(const CORBA::Exception& e) {
    cout << "Failure: "  << endl;
  }
  return 0;
}

