package examples.iiop.rmi.rmiclient;

import java.io.PrintStream;
import weblogic.utils.Debug;
import javax.naming.*;
import java.util.Hashtable;

import examples.iiop.rmi.server.wls.*;

/**
 * This client uses the remote PingServer methods.
 *
 * @author Copyright (c) 1997 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class PingClient {

  private final static boolean debug = true;

/**
 * Defines the JNDI context factory.
 */
  public final static String JNDI_FACTORY="weblogic.jndi.WLInitialContextFactory";
  
  static String url;
  static boolean remote = false;
  
  private static void usage() {
    System.err.println("Usage: java examples.iiop.rmi.rmiclient.PingClient "
                       + "iiop://<hostname>:<port> <true|false>");
    System.exit(-1);
  } 
  
  public PingClient() {}
  
  public static void main(String[] argv) throws Exception {
    if (argv.length < 1) {
      usage();
    }
    
    String url = argv[0];
    if (argv.length >1 && argv[1].equals("true"))
      remote = true;
    
    try {

      InitialContext ic = getInitialContext(url);

      Pinger obj = 
        (Pinger) ic.lookup("Pinger_iiop");
      System.out.println("Successfully connected to PingServer at " +
                         url);
      System.out.println("Ping local ...");
      obj.ping();
      if (remote)
        {
          System.out.println("Ping remote ...");
          obj.pingRemote();
        }
    }
    catch (Throwable t) {
      t.printStackTrace();
      System.exit(-1);
    }
  }

  private static InitialContext getInitialContext(String url)
       throws NamingException
  {
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, JNDI_FACTORY);
    env.put(Context.PROVIDER_URL, url);
    return new InitialContext(env);
  }
}
