package examples.iiop.wls2wls;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Collection;
import java.util.Iterator;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NamingEnumeration;
import javax.naming.Binding;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

/**
 * <p>
 * Call this servlet using an URL such as 
 * <p>
 * <code>http://localhost:<port>/examplesWebApp/InteropServlet?hostname=<hostname>&port=<port></code>
 * <p>
 *
 * @author Adapted by WebLogic, Inc.; adaptions copyright (c) 2001 by WebLogic, Inc. All Rights Reserved. 
 */

public class InteropServlet extends HttpServlet {

  private static final String DEFAULT_URL   = "iiop://localhost:5151"; // change to hostname and port of 5.1 server.
  private static final String JNDI_NAME     = "iiop-wls2wls-TraderHome";
  private static final String IIOP_USER     = "iiop";
  private static final String IIOP_PASSWORD = "password";

  /**
   * Finds the trader home on 6.1 server,
   * creates the bean and calls methods on the bean's remote interfaces.
   * 
   * @param req               HttpServletRequest
   * @param res               HttpServletResponse
   * @exception               java.io.IOException
   *                          if there is an IO error
   */
  public void doGet (HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
  {
    // Must set the content type first
    res.setContentType("text/html");
    // Now we can obtain a PrintWriter
    PrintWriter out = res.getWriter();
    out.println("<html><head><title>WebLogic 5.1 <-> 6.1 Interoperability</title></head>");
    out.println("<body>");
    out.println("<p><img src=images/bea_logo_small.gif align=right>");
    out.println("<h2>");
    out.println("WebLogic 5.1 <-> 6.1 Interoperability");
    out.println("</h2>");
    out.println("<p>Beginning examples.iiop.wls2wls example...");

    String lUrl;
    String lHostname = req.getParameter("hostname");
    String lPort = req.getParameter("port");
    if (lHostname == null || lPort == null) {
      out.println("<p>Hostname and/or Port not found.  Using default.");
      lUrl = DEFAULT_URL;
    } else {
      lUrl = "iiop://"+lHostname+":"+lPort;
    }
    
    try {
      out.println("<p>Looking up TraderHome on <b>"+lUrl+"</b>...");
      TraderHome home = lookupHome(out, lUrl);
      Trader trader = (Trader) narrow(home.create(), Trader.class);
      out.println("<p>Got TraderBean.  Performing stock transactions...");
      
      String [] stocks = {"BEAS", "MSFT", "AMZN", "HWP" };
      out.println("<p>Buying shares...");
      // execute some buys
      for (int i=0; i<stocks.length; i++) {
        int shares = (i+1) * 100;
        log("Buying "+shares+" shares of "+stocks[i]+".");
        trader.buy(stocks[i], shares);
      }
      
      out.println("<p>Selling shares...");
      // execute some sells
      for (int i=0; i<stocks.length; i++) {
        int shares = (i+1) * 100;
        log("Selling "+shares+" shares of "+stocks[i]+".");
        trader.sell(stocks[i], shares);
      }
  
      out.println("<p>Removing TraderBean...");
      // remove the Trader
      log("Removing the trader");
      trader.remove();
      
      out.println("<p><b>Done.</b>");
      out.println("</body></html>");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private TraderHome lookupHome(PrintWriter pOut, String pUrl)
    throws NamingException
  {
    try {
      // Lookup the beans home using JNDI
      Context ctx = getInitialContext(pOut, pUrl);
      Object home = ctx.lookup(JNDI_NAME);
      return (TraderHome) narrow(home, TraderHome.class);
    } catch (NamingException ne) {
      pOut.println("<p><font color=red>Error occurred while looking up TraderHome.</font>");
      log("The client was unable to lookup the EJBHome.  Please make sure ");
      log("that you have deployed the ejb with the JNDI name "+JNDI_NAME+" on the WebLogic server at "+pUrl);
      throw ne;
    }
  }

  private Context getInitialContext(PrintWriter pOut, String pUrl) throws NamingException {
    
    try {
      // Get an InitialContext
      Hashtable h = new Hashtable();
      h.put(Context.INITIAL_CONTEXT_FACTORY,
        "weblogic.jndi.WLInitialContextFactory");
      h.put(Context.PROVIDER_URL, pUrl);
      h.put(Context.SECURITY_PRINCIPAL, IIOP_USER);
      h.put(Context.SECURITY_CREDENTIALS, IIOP_PASSWORD);
      return new InitialContext(h);
    } catch (NamingException ne) {
      pOut.println("<p><font color=red>Error occurred while trying to get the InitialContext.</font>");
      log("We were unable to get a connection to the WebLogic server at "+pUrl);
      log("Please make sure that the server is running.");
      throw ne;
    }
  }

  private Object narrow(Object ref, Class c) {
    return PortableRemoteObject.narrow(ref, c);
  }
  
  public void log(String pStr)  {
    System.out.println(pStr);
  }
}
