package examples.jdbc.datasource;
import java.sql.*;
import java.util.*;
import javax.naming.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

/**
 * This servlet demonstrates using a DataSource to get a connection to
 * a database and execute a simple sql query using the connection. The
 * example uses the Cloudscape database, provided in an evaluation
 * version with WebLogic Server.
 * <font face="Helvetica">
 * 
 * <p><h3>Build the Example</h3> 
 * <ol>
 * <li> Open a new command shell.  
 * <p>
 * <li>Set up this development shell as described in <a
 * href=../../examples.html#environment>Setting up Your Environment for
 * Building and Running the Examples</a>. 
 * <li>Compile the example by executing an <font face="Courier New" size = -1>ant</font> 
 * build script or a command.
 * <p>
 * <ul>
 * <li>An <font face="Courier New" size = -1>ant</font> build script is available in the
 * <font face="Courier New" size = -1>samples/examples/jdbc/datasource</font> directory. Enter the following command
 * to execute the build script:
 * <p>
 * <pre><font face="Courier New"><b>ant</b></font></pre>
 * <li>Enter the following command to compile the example:
 * <p>
 * <pre><b>javac -d %EX_WEBAPP_CLASSES% simplesqlServlet.java</b></pre>
 * </ol>
 * <p> <li>Start WebLogic Server with the <a
 * href=../../examples.html>examples configuration</a>.
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <ol>
 *
 * <li>Make sure that the <font face="Courier New"
 * size=-1>examplesWebApp</font> is <a
 * href=../../examples.html#webApp>deployed on your server</a>.
 *
 * <p> <li> Use the Administration Console to confirm that the
 * <b>examples-dataSource-demoPool</b> DataSource is deployed on the
 * examplesServer. For more information see <a
 * href="http://e-docs.bea.com/wls/docs61/ConsoleHelp/jdbcdatasource.html">JDBC Data
 * Sources</a>.

 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/simplesqlServlet</b></pre>
 *
 * </ol>
 * <h3>There's more</h3>
 *
 * For more information on servlets see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 *
 * <p>For more information on the Cloudscape DBMS, see <a href =
 * "../../../eval/cloudscape/cloudscape.html">Using the Cloudscape
 * Database with WebLogic Server</a>
 *
 *
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  </font> */

public class simplesqlServlet extends HttpServlet {
    
    public void service(HttpServletRequest req, HttpServletResponse res) 
        throws IOException
    {        
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<html><head><title>Hello datasource!</title></head><body>");
        out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
	out.println("<H1>simplesqlServlet.java</h1> Attempting connection....");
        java.sql.Connection conn = null;
        java.sql.Statement stmt = null;
        try {
            
            // ============== Make connection to database ==================
            // Obtain a Datasource connection from the WebLogic JNDI tree.
            
            // Get a context for the JNDI look up
            Context ctx = new InitialContext();

            // Look up myDataSource
            javax.sql.DataSource ds
                = (javax.sql.DataSource) ctx.lookup ("examples-dataSource-demoPool");
            //Create a connection object
            conn = ds.getConnection();

            out.println("<p>Connection successful...<p>Executing SQL...<p>");
            
            // execute some SQL statements to demonstrate the connection. 
            stmt = conn.createStatement();
            
            try {
                stmt.execute("drop table empdemo");
                out.println("Table empdemo dropped...<p>");
            }
            catch (SQLException e) {
                out.println("<p>Table empdemo does not need to be dropped...<p>");
            }
            
            stmt.execute("create table empdemo (empid int, name varchar(30), dept int)");
            out.println("<p>Table empdemo created...");
            
            int numrows = stmt.executeUpdate("insert into empdemo values (0,'John Smith', 12)");
            out.println("<p>Number of rows inserted = " + numrows);
            

            stmt.execute("select * from empdemo");
    
            ResultSet rs = stmt.getResultSet();
            out.println("<hr>Querying data ...<br>");

            while (rs.next()) {
                out.println("<br><b>ID:  </b> " +  rs.getString("empid") +  
                            "<br><b>Name:</b> " +  rs.getString("name")  +  
                            "<br><b>Dept:</b> " +  rs.getString("dept")  + "<hr>");
            }
            
            ResultSetMetaData rsmd = rs.getMetaData();
            out.println("Querying table meta data...<p>");
            out.println("Number of Columns: " + rsmd.getColumnCount() + "<b>");
            for (int i = 1; i <= rsmd.getColumnCount(); i++) {
                out.println("<p>Column Name: "          + rsmd.getColumnName(i));
                out.println("<br>Nullable: "             + rsmd.isNullable(i));
                out.println("<br>Precision: "            + rsmd.getPrecision(i));
                out.println("<br>Scale: "                + rsmd.getScale(i));
                out.println("<br>Size: "                 + rsmd.getColumnDisplaySize(i));
                out.println("<br>Column Type: "          + rsmd.getColumnType(i));
                out.println("<br>Column Type Name: "     + rsmd.getColumnTypeName(i));
                out.println("<br><hr>");
            }
        }
        catch (Exception e) {
            out.println("Connection error:" + e);
        } finally {
            try {
            if (conn != null)
              conn.close();
            if (stmt != null)
              stmt.close();
            } catch (SQLException sqle) {
              out.println("Exception during close()" + sqle.getMessage());
            }
        }
        out.println("</b><h3>Example finished...</h3></body></html>");
    }
}










