package examples.jdbc.informix4;

import java.sql.*;
import java.util.Properties;

/**
 * This simple example shows the alternatives for making a
 * JDBC connection to an Informix instance. 
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters in login.java to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% login.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.login</b></pre>
 * 
 * </ol>
 * <h3>There's More</h3>
 *
 * For more information, see the programming guide  <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 * @author         Copyright (c) 1997-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class login {

  public static void main(String argv[])
  {
    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.login [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn1 = null;
    java.sql.Connection conn2 = null;
    try {

      // You can connect to a database with JDBC in various ways.
    
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server
    
      Driver myDriver= (Driver)
      Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn1 = myDriver.connect("jdbc:weblogic:informix4", props);
      System.out.println("Logged in successfully with style #1.");
    
      // The simplest thing to do is to embed the connection parameters in the URL.
      // Then use a Properties object to pass in the username and password.
      Properties props2 = new Properties();
      props2.put("user",     user);
      props2.put("password", password);

      conn2 = myDriver.connect(url, props2 );
    
      System.out.println("Logged in successfully with style #2.");
    } catch (Exception e) {
        System.out.println("Exception was thrown: " + e.getMessage());
    } finally {
        try {
          if (conn1 != null)
            conn1.close();
          if (conn2 != null)
            conn2.close();
        } catch (SQLException sqle) {
            System.out.println("SQLException was thrown: " + sqle.getMessage());
        }
    }
  }
}










