package examples.jdbc.informix4;

import java.sql.*;
import java.util.Properties;

/**
 *
 * This simple example shows how JDBC is used to execute DDL and
 * DML and requires the table <tt>empdemo</tt>. Before working with <tt>records.java</tt>, create the
 * <tt>empdemo</tt> using the <b>simplesql</b> example.
 * 
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% records.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.records</b></pre>
 * 
 * </ol>
 * <h3>There's More</h3>
 *
 * For more information, see the programming guide  <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All rights reserved
 */

public class records {
  
  public static void main(String argv[])
  {
    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.records [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn = null;
    java.sql.PreparedStatement pstmt = null;
    java.sql.PreparedStatement pstmt2 = null;
    try {

      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port); // port on which Informix server listens
      props.put("db",       db); // name of database on Informix server

      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:informix4", props);
    
      // Insert 100 records
      System.out.println("Inserting 100 records...");
      String inssql = "insert into empdemo(empid, name, dept) values (?, ?, ?)";
      pstmt = conn.prepareStatement(inssql);
    
      for (int i = 0; i < 100; i++) {
        pstmt.setInt(1, i);
        pstmt.setString(2, "Person " + i);
        pstmt.setInt(3, i);
        pstmt.execute();
      }
    
      pstmt.close();
    
      // Update 100 records
      System.out.println("Updating 100 records...");
      String updsql = "update empdemo set dept = dept + ? where empid = ?";
      pstmt2 = conn.prepareStatement(updsql);
    
      for (int i = 0; i < 100; i++) {
        pstmt2.setInt(1, i);
        pstmt2.setInt(2, i);
        pstmt2.execute();
      }

      // if this Database is not in autocommit mode, then commit the work
      if (!conn.getAutoCommit()) {
        conn.commit();
      }
    } catch (Exception e) {
        System.out.println("Caught Exception: " + e.getMessage());
    } finally {
        try {
          if (pstmt != null)
            pstmt.close();
          if (pstmt2 != null)
            pstmt2.close();
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLExcepion was thrown: " + sqle.getMessage());
        }
    }
  } 
}










