package examples.jdbc.informix4;

import java.sql.*;
import java.util.Properties;

/**
 * 
 * This simple example shows how data and result set metadata
 * is selected with JDBC.
 * It assumes the table <tt>empdemo exists</tt>. This table is created
 * in the <a href="simplesql.html"><font
 * face="Courier New" size=-1>simplesql</font></a> example.
 * <p>
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% simpleselect.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.simpleselect</b></pre>
 * 
 * </ol>
 *
 * <h3>There's More</h3>
 *
 * For more information, see <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 * @author Copyright (c) 1996-2001 by BEA Systems, Inc.  All Rights Reserved.
 */

public class simpleselect {
  
  public static void main(String argv[])
  {
    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.simpleselect [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn = null;
    java.sql.ResultSet rs    = null;
    java.sql.Statement stmt  = null;
    
    try {
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server
    

      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:informix4", props);
    
      stmt = conn.createStatement();
    
      stmt.execute("select * from empdemo");
    
      rs = stmt.getResultSet();
    
      while (rs.next()) {
          System.out.println(rs.getString("empid") + " - " + 
                             rs.getString("name")  + " - " + 
                             rs.getString("dept"));
      }
    
      ResultSetMetaData rsmd = rs.getMetaData();
      
      System.out.println("Number of Columns: " + rsmd.getColumnCount());
      for (int i = 1; i <= rsmd.getColumnCount(); i++) {
          System.out.println("Column Name: "          + rsmd.getColumnName(i));
          System.out.println("Nullable: "             + rsmd.isNullable(i));
          System.out.println("Precision: "            + rsmd.getPrecision(i));
          System.out.println("Scale: "                + rsmd.getScale(i));
          System.out.println("Size: "                 + rsmd.getColumnDisplaySize(i));
          System.out.println("Column Type: "          + rsmd.getColumnType(i));
          System.out.println("Column Type Name: "     + rsmd.getColumnTypeName(i));
          System.out.println("");
      }
    } catch (Exception e) {
        System.out.println("Exception was thrown: " + e.getMessage());
    } finally {
        try {
          if (stmt != null)
            stmt.close();
          if (rs != null)
            rs.close();
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLException was thrown: " + sqle.getMessage());
        }
    }
  }
}

