/**
 * SampleConfig.java
 *
 * Jaas sample configuration
 *
 * @author Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

package examples.security.jaas;

import java.util.Hashtable;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.AppConfigurationEntry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

/**
 * Sample configuration class for JAAS user authentication.
 */

public class SampleConfig extends Configuration
{
  /**
   *
   * Create a new Configuration object.
   */
  public SampleConfig()
  {
    // No Implementation
  }

  /**
   * Retrieve the specified configuration from the Configuration object using an application name as an index.
   */
  public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName)
  {
    // Get the specified configuration file
    String configFileName = System.getProperty("weblogic.security.jaas.Policy");

    // Parse configuration, return configuration entries
    return ConfigParser.parse(configFileName, applicationName);
  }

  /**
   * Refresh and reload the Configuration object by reading all of the login configurations again.
   */
  public void refresh()
  {
    // No Implementation
  }
}
