package examples.security.net;


import java.net.InetAddress;


/**
 * Abstract filter rule.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
abstract class FilterEntry
{
  static final int ALLOW = 0;
  static final int DENY = 1;
  static final int IGNORE = 2;
    
  private int protomask;
  private boolean action;

  protected FilterEntry(boolean action, int protomask)
  {
    this.protomask = protomask;
    this.action = action;
  }
    
  int check(InetAddress addr, int protocol)
  {
    if (match(addr) && match(protocol))
    {
      return action ? ALLOW : DENY;
    }
    return IGNORE;
  }

  protected abstract boolean match(InetAddress addr);

  protected boolean match(int protocol)
  {
    return protomask == 0 || (protocol & protomask) != 0;
  }
}

