package examples.security.net;


import java.net.InetAddress;


/**
 * Slow filter rule.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
class SlowFilterEntry
  extends FilterEntry
{
  private String pattern;

  SlowFilterEntry(boolean action, int protomask, String pattern)
  {
    super(action, protomask);
    this.pattern = pattern.toLowerCase().substring(1);
  }
    
  protected boolean match(InetAddress addr)
  {
    return addr.getHostName().toLowerCase().endsWith(pattern);
  }
}
