package examples.security.proxy;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import weblogic.common.ProxyAuthenticator;

/** This example class provides a graphical implementation of the
 * <code>weblogic.net.ProxyAuthenticator</code> interface.  It queries
 * the user for a username and password for a proxy server that
 * requires authentication.  
 * <p> 
 * See the documentation for <code>weblogic.common.net.ProxyAuthenticator
 * </code> for more details.
 *
 * <p> 
 * The class <b>must</b> be public.
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class GUIProxyAuthenticator extends Frame
implements ProxyAuthenticator, ActionListener, WindowListener {

    private Button ok, cancel;
    private TextField user, passwd;
    private Label loginPrompt, hostNport;
    private boolean okPressed = false;

    private void setIconImage() {
	try {
	    java.net.URL url = getClass().getResource("/weblogic/graphics/W.gif");
	    if (url == null)
		return;
	    Toolkit tk = Toolkit.getDefaultToolkit();
	    Image img = tk.createImage((java.awt.image.ImageProducer) url.getContent());
	    if (img != null) {
		setIconImage(img);
	    }
	} catch (Exception ignore) {}
    }

    /** 
     * The class must have a public, default constructor.
     */
    public GUIProxyAuthenticator() {
	super("Proxy Authentication Required");
	setLayout(new GridBagLayout());
	GridBagConstraints gbc = new GridBagConstraints();
	/* top,left,bottom,right */
	gbc.insets = new Insets(5,5,5,5);
	Font f = new Font("SansSerif", Font.PLAIN, 12);
	setBackground(Color.lightGray);
	setIconImage();

	/* 0th row: label for hostname + port */
	gbc.gridwidth = gbc.REMAINDER;
	gbc.gridheight = 1;
	gbc.fill = gbc.HORIZONTAL;
	gbc.anchor = gbc.CENTER;
	gbc.gridx = gbc.gridy = 0;
	gbc.weightx = gbc.weighty = 1.0;
	/* text will change when we get the actual host & port */
	hostNport = new Label("Proxy Host:Port:");
	hostNport.setFont(f);
	add(hostNport, gbc);

	/* 1st row: label for login prompt */
	gbc.gridx = 0;
	gbc.gridy++;
	/* text may change when we get the actual login prompt */
	loginPrompt = new Label("Proxy Authentication Required");
	loginPrompt.setFont(f);
	add(loginPrompt, gbc);

	/* 2nd row: user name */
	gbc.gridx = 0;
	gbc.gridy++;
	gbc.weighty = 0.0;
	gbc.anchor = gbc.EAST;
	gbc.gridwidth = 1;
	gbc.fill = gbc.NONE;
	f = new Font("SansSerif", Font.BOLD, 12);
	Label l = new Label("User name:");
	l.setFont(f);
	add(l, gbc);
	gbc.gridx++;
	gbc.anchor = gbc.WEST;
	gbc.fill = gbc.HORIZONTAL;
	user = new TextField("", 12);
	user.setBackground(Color.white);
	add(user, gbc);

	/* 3rd row: password */
	gbc.gridx = 0;
	gbc.gridy++;
	gbc.anchor = gbc.EAST;
	gbc.fill = gbc.NONE;
	l = new Label("Password:");
	l.setFont(f);
	add(l, gbc);
	gbc.gridx++;
	gbc.anchor = gbc.WEST;
	gbc.fill = gbc.HORIZONTAL;
	passwd = new TextField("", 12);
	passwd.setEchoChar('*');
	passwd.setBackground(Color.white);
	add(passwd, gbc);

	/* 4th row: ok + cancel buttons */
	gbc.gridx = 0;
	gbc.gridy++;
	gbc.anchor = gbc.EAST;
	gbc.fill = gbc.NONE;
	ok = new Button("OK");
	ok.setFont(f);
	ok.addActionListener(this);
	add(ok, gbc);
	gbc.gridx++;
	gbc.anchor = gbc.WEST;
	cancel = new Button("Cancel");
	cancel.setFont(f);
	cancel.addActionListener(this);
	add(cancel, gbc);

	addWindowListener(this);
    }

    public void init(String proxyHost, int proxyPort, String authType,
		     String promptString) {
	if (authType != null) {
	    setTitle('"' + authType + "\" Proxy Authentication Required");
	}
	hostNport.setText("Proxy Host:Port " + proxyHost + ':' + proxyPort);
	loginPrompt.setText('"' + promptString + '"');
    }

    public synchronized String[] getLoginAndPassword() {
      /* pack, and figure out the size the frame wants to be */
      pack();
      Dimension d = getSize();
      /* front & center */
      Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
      int xt = (screen.width - d.width)/2;
      int yt = (screen.height - d.height)/2;
      setLocation(new Point(xt, yt));
      setVisible(true);
      toFront();
      
      while (isVisible()) {
        try {
          wait();
        } catch (InterruptedException e) {
        }
      }
      
      /* clean up GUI resources */
      dispose();
      if (!okPressed)
        return null;
      
      String u = user.getText();
      String p = passwd.getText();
      if (u == null || u.length() == 0 ||
          p == null || p.length() == 0) {
        return null;
      }
      
      String[] ret = new String[2];
      ret[0] = u;
      ret[1] = p;
      return ret;
    }
  
  /* ActionListener Interface */
  public synchronized void actionPerformed(ActionEvent ev) {
    Object o = ev.getSource();
    if (o == ok) {
      okPressed = true;
      setVisible(false);
      notifyAll();
    } else if (o == cancel) {
      okPressed = false;
      setVisible(false);
      notifyAll();
    }
  }
  
  /* WindowListener Interface */
  /** WindowListener methods */
  public void windowActivated(WindowEvent e) { }
  public void windowClosed(WindowEvent e) {}
  public synchronized void windowClosing(WindowEvent e) {
    okPressed = false;
    setVisible(false);
    notifyAll();
  }
  
  public void windowDeactivated(WindowEvent e) {}
  public void windowDeiconified(WindowEvent e) {}
  public void windowIconified(WindowEvent e) {}
  public void windowOpened(WindowEvent e) {}
  
  /* unit test */
  public static void main(String[] a) {
    GUIProxyAuthenticator gpa = new GUIProxyAuthenticator();
    gpa.init("dumbarton", 8080, "Basic", "Authenticate with proxy");
    String[] unp = gpa.getLoginAndPassword();
    if (unp == null) {
      System.out.println("no authentication info provided");
    } else {
      System.out.println("username '" + unp[0] + "' passwd '" + unp[1] + "'");
    }
    System.exit(0);
  }
}


    
