package examples.security.rdbmsrealm;


import java.security.Principal;
import java.util.Hashtable;
import weblogic.security.acl.FlatGroup;


/**
 * This class is the representation of a group from the database.
 *
 * We assume that the database we are connecting to supports autocommit=true.
 * If your database does not support autocommit=true, you have to use explicit
 * commit's wherever you are updating the database.
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class RDBMSGroup
  extends FlatGroup
{
  private RDBMSRealm realm;


  RDBMSGroup(String name, RDBMSRealm realm, Hashtable members)
  {
    super(name, realm, members);
    this.realm = realm;
  }


  RDBMSGroup(String name, RDBMSRealm realm)
  {
    super(name, realm);
    this.realm = realm;
  }


  protected Class getUserClass()
  {
    return RDBMSUser.class;
  }


  public boolean addMember(Principal principal)
  {
    if (!(principal instanceof RDBMSUser) && !(principal instanceof RDBMSGroup))
    {
      throw new SecurityException("attempt to add non-RDBMS principal");
    }

    if (this.equals(principal))
    {
      throw new SecurityException("adding group to self");
    }

    if (isMember(principal))
    {
      return false;
    }

    return realm.addGroupMember(this, principal) && addMemberInternal(principal);
  }


  public boolean removeMember(Principal principal)
  {
    if (!(principal instanceof RDBMSUser) && !(principal instanceof RDBMSGroup))
    {
      throw new SecurityException("attempt to remove non-RDBMS principal");
    }

    if (this.equals(principal))
    {
      throw new SecurityException("removing group from self");
    }

    if (!isMember(principal))
    {
      return false;
    }

    return realm.removeGroupMember(this, principal) &&
      removeMemberInternal(principal);
  }


  Hashtable getMembers()
  {
    return members;
  }
}
