# Defines a simple schema and populates it with some example values.
# The queries in the rdbmsrealm.properties file in this directory are
# made against this schema.

# This schema is not very efficient or flexible (for example, it
# doesn't support empty groups or ACLs, and it forces us to make group
# operations undesirably slow).  It would make more sense to maintain
# tables of users and groups mapping name to ID, and then use the
# numeric IDs in all other tables.  We maintain the current schema for
# backwards compatibility, but you may wish to modify it before any
# kind of serious use.



# Note that these DROP requests will fail the very first time.

DROP TABLE aclentries;
DROP TABLE groupmembers;
DROP TABLE users;

CREATE TABLE aclentries (A_NAME varchar(255), A_PRINCIPAL varchar(255), A_PERMISSION varchar(255));
CREATE TABLE groupmembers(GM_GROUP varchar(255), GM_MEMBER varchar(255));
CREATE TABLE users (U_NAME varchar(255), U_PASSWORD varchar(255));

insert into users values ('anno',     'anno');
insert into users values ('bob',      'bob');
insert into users values ('bryan',    'bryan');
insert into users values ('francine', 'francine');
insert into users values ('jason',    'jason');
insert into users values ('kevin',    'kevin');
insert into users values ('mike',     'mike');
insert into users values ('scott',    'scott');

insert into groupmembers values('engineering', 'anno');
insert into groupmembers values('engineering', 'bryan');
insert into groupmembers values('engineering', 'francine');
insert into groupmembers values('engineering', 'sysadmin');
insert into groupmembers values('marketing',   'mike');
insert into groupmembers values('marketing',   'scott');
insert into groupmembers values('sales',       'jason');
insert into groupmembers values('sysadmin',    'kevin');

insert into aclentries values ('disk',          'engineering', 'read');
insert into aclentries values ('disk',          'engineering', 'write');
insert into aclentries values ('disk',          'marketing',   'read');
insert into aclentries values ('disk',          'sales',       'execute');
insert into aclentries values ('disk',          'scott',       'read');
insert into aclentries values ('fancy printer', 'bob',         'print');
insert into aclentries values ('fancy printer', 'marketing',   'print');
insert into aclentries values ('old printer',   'engineering', 'print');
insert into aclentries values ('old printer',   'sysadmin',    'print');

