package examples.security.sslclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * SSLClientServlet is a simple servlet wrapper of examples.security.sslclient.SSLClient
 *
 * @see SSLClient
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class SSLClientServlet extends HttpServlet {

  

  public void service(HttpServletRequest request, HttpServletResponse response) 
    throws ServletException, IOException {

    response.setContentType("text/html");
    response.setHeader("Pragma", "no-cache"); // HTTP 1.0
    response.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
    ServletOutputStream out = response.getOutputStream();

    out.println("<br><h2>ssl client test</h2><br><hr>");
    String[] target = request.getParameterValues("url");
    try {

      out.println("<h3>wls ssl client classes</h3><br>");
      out.println("java SSLClient wls localhost 7001 7002 /examplesWebApp/SnoopServlet.jsp<br>");
      out.println("<pre>");
      SSLClient.wlsURLConnect("localhost", "7001", "7002", "/examplesWebApp/SnoopServlet.jsp", out);
      out.println("</pre><br><hr><br>");

      out.println("<br><h3>jsse ssl client classes</h3><br>");
      out.println("java SSLClient jsse localhost 7001 7002 /examplesWebApp/SnoopServlet.jsp<br>");
      out.println("<pre>");
      SSLClient.jsseURLConnect("localhost", "7001", "7002", "/examplesWebApp/SnoopServlet.jsp", out);
      out.println("</pre><br><hr><br>");

    } catch (IOException ioe) {
      out.println("<br><pre> "+ioe.getMessage()+"</pre>");
      ioe.printStackTrace();
    }

  }

}
