package examples.security.sslclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import java.util.Hashtable;

import weblogic.security.PEMInputStream;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLContext;
import weblogic.security.SSL.SSLSocket;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.SSL.TrustManager;

/**
 * SSLSocketClient uses the SSLSocket and SSLSocketFactory directly to use a new SSL connection.
 *
 * @see SSLClient
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class SSLSocketClient {

  public void SSLSocketClient() {}

  public static void main (String [] argv) 
    throws IOException {
    if ((argv.length < 2) || (argv.length > 3)) {
      System.out.println("usage:   java SSLSocketClient host sslport <HostnameVerifier>");
      System.out.println("example: java SSLSocketClient server2.weblogic.com 443 MyHVClassName");
      System.exit(-1);
    }

    try {
      System.out.println("\nhttps://" + argv[0] + ":" + argv[1]);
      System.out.println(" Creating the SSLContext");
      SSLContext sslCtx = SSLContext.getInstance("https");

      System.out.println(" Initializing the SSLContext with client\n" + 
                         "  identity (certificates and private key)\n" + 
                         "  and HostnameVerifier");
      // Similar to examples.security.acl.AltClient, the SSLCertificates is
      // an ordered array of input streams:
      //   private key, cilent cert, client cert authority
      // use a PEMInputStream for .pem files and a BufferedInputStream
      //  for .der files
      InputStream [] ins = new InputStream[3];
      ins[0] = new PEMInputStream(new FileInputStream("demokey1024.pem"));
      ins[1] = new PEMInputStream(new FileInputStream("democert1024.pem"));
      ins[2] = new PEMInputStream(new FileInputStream("ca1024.pem"));
      // ins[x] = new BufferedInputStream(new FileInputStream("ca1024.der"));

      sslCtx.loadLocalIdentity(ins);

      HostnameVerifier hVerifier = null;
      if (argv.length < 3)
        hVerifier = new NulledHostnameVerifier();
      else
        hVerifier = (HostnameVerifier) Class.forName(argv[2]).newInstance();

      sslCtx.setHostnameVerifier(hVerifier);

      System.out.println(" Creating new SSLSocketFactory with SSLContext");
      SSLSocketFactory sslSF = (SSLSocketFactory) sslCtx.getSocketFactory();

      System.out.println(" Creating and opening new SSLSocket with SSLSocketFactory");
      // using createSocket(String hostname, int port)
      SSLSocket sslSock = (SSLSocket) sslSF.createSocket(argv[0],
                                                         new Integer(argv[1]).intValue());
      System.out.println(" SLSSocket created");
      sslSock.close();
      System.out.println(" SSLSocket closed");

    } catch (Exception e) {
      e.printStackTrace();
    }

    /////////////////////////////////

    try {
      System.out.println("\nhttps://" + argv[0] + ":" + argv[1]);
      System.out.println(" Creating the SSLContext");
      SSLContext sslCtx = SSLContext.getInstance("https");

      System.out.println(" Initializing the SSLContext with client\n" + 
                         "  identity (certificates and private key),\n" + 
                         "  HostnameVerifier, AND NulledTrustManager");
      // Similar to examples.security.acl.AltClient, the SSLCertificates is
      // an ordered array of input streams:
      //   private key, cilent cert, client cert authority
      // use a PEMInputStream for .pem files and a BufferedInputStream
      //  for .der files
      InputStream [] ins = new InputStream[3];
      ins[0] = new PEMInputStream(new FileInputStream("demokey1024.pem"));
      ins[1] = new PEMInputStream(new FileInputStream("democert1024.pem"));
      ins[2] = new PEMInputStream(new FileInputStream("ca1024.pem"));
      // ins[x] = new BufferedInputStream(new FileInputStream("ca1024.der"));

      sslCtx.loadLocalIdentity(ins);

      HostnameVerifier hVerifier = null;
      if (argv.length < 3)
        hVerifier = new NulledHostnameVerifier();
      else
        hVerifier = (HostnameVerifier) Class.forName(argv[2]).newInstance();

      sslCtx.setHostnameVerifier(hVerifier);

      TrustManager tManager = new NulledTrustManager();

      sslCtx.setTrustManager(tManager);

      System.out.println(" Creating new SSLSocketFactory with SSLContext");
      SSLSocketFactory sslSF = (SSLSocketFactory) sslCtx.getSocketFactory();

      System.out.println(" Creating and opening new SSLSocket with SSLSocketFactory");
      // using createSocket(String hostname, int port)
      SSLSocket sslSock = (SSLSocket) sslSF.createSocket(argv[0],
                                                         new Integer(argv[1]).intValue());
      System.out.println(" SSLSocket created");
      sslSock.close();
      System.out.println(" SSLSocket closed");

    } catch (Exception e) {
      e.printStackTrace();
    }


  }

}
