package examples.servlets;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
/**
 * 
 * This servlet example demonstrates how to create and retrieve a
 * cookie and how to set a maximum age on a cookie. 
 *
 * <p> The servlet displays how many times it has been visited by all
 * clients since the server was started, and also displays how many
 * times each client has visited in the 10 seconds that have passed
 * since the last visit.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up your environment for 
 * building and running the examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% CookieCounter.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * <li>Copy the file <font face = "Courier New"
 * size=-1>cookie.jpg</font>, located in the <font face = "Courier
 * New" size=-1>samples/examples/servlets</font> directory in your
 * WebLogic Server installation, to the <font face = "Courier New"
 * size=-1>config/examples/applications/examplesWebApp</font>
 * directory.  This directory is the location of the
 * publicly-available files of the examplesWebApp.
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New"
 * size=-1>examplesWebApp</font> is <a
 * href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Use a web browser to load  the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/CookieCounter</b></pre>
 *
 * <li>Click reload in your browser (or type Control-R in most
 * browsers) and observe that the numbers on both lines of text
 * increment each time you click reload.
 *
 * <p><li>Wait at least 10 seconds and click reload again in your
 * browser. Note that the text of the second line changes,
 * demonstrating that the cookie has expired after 10 seconds. If you
 * click on reload again, the second line restarts the count from 1.
 *
 * </ol>
 * <h3>Notes</h3>
 * If you have cookies disabled in your browser, the
 * servlet will not work. For a failsafe way to handle non-cookie-friendly
 * web browsers, see the <a href="SessionServlet.html">SessionServlet</a> example. 
 * <p>
 * On HP platforms, the cookie may not expire after 10 seconds.
 * </ol>
 *
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  */



public class CookieCounter extends HttpServlet {
  private int pageCount = 0;

  /**
   * Initializes the servlet. Looks for the property "initial" to set the 
   * pageCount variable. 
   */
  public void init(ServletConfig config) throws ServletException  {
    super.init(config);
    String s = getInitParameter("initial");
    if (s == null)
      pageCount = 0;
    else
      pageCount = Integer.parseInt(s);
  }

  /**
   * Implements the service method of the servlet. 
   */
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws IOException
  {
    boolean cookieFound = false;
    Cookie thisCookie = null;
    
    // We must set the content type before calling getWriter()
    res.setContentType("text/html");
    // Now we can call getWriter()
    PrintWriter out = res.getWriter();
    
    // Try to retrieve the cookie from the request.
    Cookie[] cookies = req.getCookies();
    for(int i=0; i < cookies.length; i++) {
      thisCookie = cookies[i];
      if (thisCookie.getName().equals("CookieCount")) {
        cookieFound = true;
        break;
      }
    }
    
    if (cookieFound == false) {
      // Create a new Cookie and set it's age. 
      thisCookie = new Cookie("CookieCount", "1");
      thisCookie.setMaxAge(60*1);
      // Add the new cookie to the response
      res.addCookie(thisCookie);
    }
    
    out.println("<html><head>\n" +
                "<title>Cookie Counter</title>\n" +
                "</head>\n" +
                "<body bgcolor=#ffffff><p><img src=images/BEA_Button_Final_web.gif align=right><font color=red>" +
                "<center><h1>Cookie Counter</h1></center></font>");
    pageCount++;
    out.println("<p><img src=\"cookie.jpg\" align=left>");
    out.println("<font color=blue size=+1>");
    out.println("<p><br><br><br>This page has been visited " + pageCount +
                (pageCount==1?" time":" times") + 
                " before.\n");
    
    // Display client specific count details
    if (cookieFound) {
      int cookieCount = Integer.parseInt(thisCookie.getValue());
      cookieCount++;
      // Set the new value of the cookie, and add it to the response
      thisCookie.setValue(String.valueOf(cookieCount));
      thisCookie.setMaxAge(10);
      res.addCookie(thisCookie);
      
      out.println("<p>You have visited this page " +
                  thisCookie.getValue() +
                  (cookieCount==1?" time":" times") +
                  " within the past 10 seconds.\n");
      
    } else {
      out.println("<p>Either you haven't visited this page in the last 10 seconds, "+
                  "or your browser doesn't like cookies!\n");
    }
    out.println("</body></html>");
    // Do not close the printWriter. 
  }
}

