package examples.servlets;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

import weblogic.html.*;


/**
 * 
 * This example constructs an htmlKona servlet page that prints
 * "Hello world!" on it. 
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up your environment for 
 * building and running the examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% HelloKonaServlet.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 *<dl>
 *<dd> Make sure that the <font face="Courier New"
 *size=-1>examplesWebApp</font> is <a
 *href=../examples.html#webApp>deployed on your server</a>. 
 * </dl>
 * <p><h3>Run the example</h3>
 *<dl><dd>
 * Use a web browser to load  the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/HelloKonaServlet</b></pre>
 *</dl>
 * <h3>There's More...</h3>
 *
 * <p> For more information on servlets see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 *
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  */


public class HelloKonaServlet extends HttpServlet {

  /**
   * A very simple implementation of the service method that
   * constructs an htmlKona servlet page and outputs "Hello world!".
  */
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws IOException
  {
    res.setContentType("text/html");
    ServletPage page = new ServletPage("Hello World!");
    page.getBody().addElement("Hello world from htmlKona!");
    page.output(res.getOutputStream()); 
  }
}
