package examples.servlets;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

/**
 * 
 * The HelloWorld2 servlet uses initialization parameters to display
 * two strings in the output ("Welcome WebLogic Developer!"). If the initialization parameters are not
 * defined, default strings defined in this example are
 * used. Initialization parameters are defined in the <font
 * face="Courier New" size=-1>web.xml</font> file that defines a Web
 * Application, in this case the <font face="Courier New"
 * size=-1>examplesWebApp</font>. The <font face="Courier New"
 * size=-1>web.xml</font> file is located in your WebLogic Server
 * distribution at <font face="Courier New"
 * size=-1>config/examples/applications/examplesWebApp/WEB-INF/web.xml</font>.  
 * 
 * <p>The <a href="HelloWorld3.html"><font face="Courier New"
 * size=-1>HelloWorld3</font></a> example contains exactly the same
 * Java code as the <font face="Courier New" size=-1>HelloWorld2</font>
 * example, but the initialization parameters are not defined in the
 * <font face="Courier New" size=-1>web.xml</font> file.
 *
 * <p><h3>Build the Example</h3> <ol>
 * <li> Open a new command shell.  
 *
 * <p><li>Set up this development shell as described in <a
 * href=../examples.html#environment>Setting up Your Environment for
 * Building and Running the Examples</a>. 
 *
 * <p> <li>Compile the servlet
 * using the following command line: <pre> $ <b>javac -d %EX_WEBAPP_CLASSES% HelloWorld2.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font> is <a href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <dl>
 * <dd>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/HelloWorld2</b></pre>
 *
 * </dl>
 * <h3>There's more</h3>
 *
 * For more information on servlets see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
*/

public class HelloWorld2 extends HttpServlet {
  
  String defaultGreeting;
  String defaultName;
  
  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
    
    if ((defaultGreeting = getInitParameter("greeting")) == null)
      defaultGreeting = "Hello";
    
    if ((defaultName = getInitParameter("person")) == null)
      defaultName = "World";
  }
  
  /**
   * A very simple implementation of the service method, in
   * which we output the contents of a static html page
   */
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws IOException
  {
    // Must set the content type first
    res.setContentType("text/html");
    // Now we can obtain a PrintWriter
    PrintWriter out = res.getWriter();
    
    out.println("<html><head><title>Hello World!</title></head>");
    //out.println("<body><h1>Hello World!</h1></body></html>");
    out.println("<body>");
    out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
    out.println("<h1>");
    out.println(defaultGreeting + " " + defaultName + "!");
    out.println("</h1></body></html>");
    // Do not close the output stream or print writer. 
  }
}
