package examples.servlets;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

/**
 * 
 * The <font face="Courier New" size=-1>HelloWorld3</font> example contains exactly the same
 * Java code as the <font face="Courier New" size=-1>HelloWorld2</font>
 * example, except that the initialization parameters are not defined in the
 * <font face="Courier New" size=-1>web.xml</font> file.
 *
 * The HelloWorld2 servlet uses initialization parameters to display
 * two strings in the output ("Welcome WebLogic Developer!"). If the
 * initialization parameters are not defined, the default strings
 * defined in this example are used. 
 *
 * <p> However, because initialization parameters are <i>not</i> defined for
 * the HelloWorld3 servlet, the HelloWorld3 servlet checks for a
 * request parameter called "name". If the "name" request parameter exists, the
 * servlet uses its value in the greeting.  
 *
 *
 * <p><h3>Build the Example</h3> <ol>
 * <li> Open a new command shell.  
 *
 * <p><li>Set up this development shell as described in <a
 * href=../examples.html#environment>Setting up Your Environment for
 * Building and Running the Examples</a>. 
 *
 * <p> <li>Compile the servlet using the following command line: 
 * <pre> * $ <b>javac -d %EX_WEBAPP_CLASSES% HelloWorld3.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font> is <a href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <ol>
 *
 * <li>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/HelloWorld3</b></pre>
 * Note that the greeting displayed in your browser is "Hello World!"
 *
 * <p><li>Now change the URL in your Web browser to
 * <pre><b>http://localhost:7001/examplesWebApp/HelloWorld3?name=Alfred</b></pre>
 * Note that the greeting displayed in your browser is now "Hello Alfred!"
 * </ol>
 *
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  */

public class HelloWorld3 extends HttpServlet {
  
    String defaultGreeting;
    String defaultName;
  
    public void init(ServletConfig config) throws ServletException
    {
        super.init(config);
        
        // Check for initialization parameters. If there are no
        // initialization parameters (detected when the getInitParameter()
        // method returns null), default strings are assigned.
    
        if ((defaultGreeting = getInitParameter("greeting")) == null)
            defaultGreeting = "Hello";
        
        if ((defaultName = getInitParameter("person")) == null)
            defaultName = "World";
    }
    
    public void service(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        
        // Check for a request parameter called "name." If the
        // parameter exists (detected when the getParameterValues()
        // method does not return null), use its value for the
        // greeting.

        String name, paramName[];
        if ((paramName = req.getParameterValues("name")) 
            != null) {
            name = paramName[0];
        }
        else {
            name = defaultName;
        }
        
        // Must set the content type first
        res.setContentType("text/html");
        // Now we can obtain a PrintWriter
        PrintWriter out = res.getWriter();
        
        out.println("<html><head><title>Hello World3.java</title></head>");
        out.println("<body>");
        out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
        out.println("<h1>");
        out.println(defaultGreeting + " " + name + "!");
        out.println("</h1></body></html>");
        // Do not close the output stream or print writer. 
    }
}



