package examples.webservices.message;

import java.io.StringWriter;

import java.util.Properties;

import java.net.URL;

import javax.naming.Context;
import javax.naming.InitialContext;

import org.w3c.dom.Element;

import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;

import weblogic.soap.WebServiceProxy;
import weblogic.soap.SoapMethod;
import weblogic.soap.SoapType;

import weblogic.soap.codec.CodecFactory;
import weblogic.soap.codec.SoapEncodingCodec;
import weblogic.soap.codec.LiteralCodec;

public class ConsumerClient{
  public static void main(String[] args) throws Exception{
    String url = "http://localhost:7001";

     // Parse the arguments list
    if (args.length > 1) {
      System.out.println("Usage: java examples.webservices.message.ConsumerClient http://hostname:port");
      return;
    } else if (args.length == 1) {
      url = args[0];
    }

    Properties h = new Properties();

    h.put(Context.INITIAL_CONTEXT_FACTORY,
         "weblogic.soap.http.SoapInitialContextFactory");
    h.put("weblogic.soap.verbose", "true");

    CodecFactory factory = CodecFactory.newInstance();
    factory.register(new SoapEncodingCodec());
    factory.register(new LiteralCodec());

    h.put("weblogic.soap.encoding.factory", factory);

    Context context = new InitialContext(h);

    WebServiceProxy proxy = (WebServiceProxy)context.lookup(url + "/msg/Receiver/Receiver.wsdl");

    SoapMethod method = proxy.getMethod("receive");

    while(true){
      Object result = method.invoke(null);
      OutputFormat    format  = new OutputFormat();
      StringWriter  stringOut = new StringWriter();
      XMLSerializer    serial = new XMLSerializer( stringOut, format );
      serial.asDOMSerializer();
      serial.serialize((Element)result); 
      System.out.println(stringOut.toString());
    }
  }
}
