package examples.webservices.message;

import java.util.Properties;

import java.net.URL;

import javax.naming.Context;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import weblogic.apache.xerces.dom.DocumentImpl;

import weblogic.soap.WebServiceProxy;
import weblogic.soap.SoapMethod;
import weblogic.soap.SoapType;

import weblogic.soap.codec.CodecFactory;
import weblogic.soap.codec.SoapEncodingCodec;
import weblogic.soap.codec.LiteralCodec;

public class ProducerClient{
  public static void main(String[] args) throws Exception{
    String url = "http://localhost:7001";
    // Parse the arguments list
    if (args.length != 2) {
      System.out.println("Usage: java examples.webservices.message.ProducerClient http://hostname:port \"message\"");
      return;
    } else if (args.length == 2) {
      url = args[0];
    }

    Properties h = new Properties();

    h.put(Context.INITIAL_CONTEXT_FACTORY,
         "weblogic.soap.http.SoapInitialContextFactory");

    h.put("weblogic.soap.verbose", "true" );

    CodecFactory factory = CodecFactory.newInstance();
    factory.register(new SoapEncodingCodec());
    factory.register(new LiteralCodec());

    h.put("weblogic.soap.encoding.factory", factory);

    Context context = new InitialContext(h);

    WebServiceProxy proxy = (WebServiceProxy)context.lookup(url +
    "/msg/Sender/Sender.wsdl");

    SoapMethod method = proxy.getMethod("send");

    String toSend = args.length == 0 ? "No arg to send" : args[1];

    Document doc = new DocumentImpl();
    Element root = doc.createElement("message");
    Element element = doc.createElement("text");
    element.appendChild(doc.createTextNode(toSend));
    root.appendChild(element);
    doc.appendChild(root);

    Object result = method.invoke( new Object[]{ root } );
  }
}

