package examples.webservices.rpc.javaClient;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;

import examples.webservices.rpc.weatherEJB.Weather;
//import examples.webservices.rpc.weatherEJB.WeatherFactory;

/**
 * This class demonstrates a java client consuming a WebService.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class Client{

  public static void main( String[] args) throws Exception{
    String url       = "http://localhost:7001";

    // Parse the argsument list
    if (args.length > 1) {
      System.out.println("Usage: java examples.webservices.rpc.javaClient.Client http://hostname:port");
      return;
    } else if (args.length == 1) {
      url = args[0];
    }

    Properties h = new Properties();

    h.put(Context.INITIAL_CONTEXT_FACTORY,
         "weblogic.soap.http.SoapInitialContextFactory");

    h.put("weblogic.soap.wsdl.interface",
         Weather.class.getName() );

    h.put("weblogic.soap.verbose", "true" );

    Context context = new InitialContext(h);
//    Weather service = WeatherFactory.getService();
      Weather service = (Weather)context.lookup(url+"/weather/statelessSession.WeatherHome/statelessSession.WeatherHome.wsdl");
    System.out.println("Temperature in Beverly Hills is " + service.getTemp("90210"));
  }
}
